/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.expectation;

import java.util.ArrayList;
import java.util.List;
import org.qaddict.Expectation;
import org.qaddict.evaluation.EvaluationNode;
import org.qaddict.expectation.ExpectationDescription;
import org.qaddict.expectation.FluentTransformation;
import org.qaddict.expectation.OperatorExpectation;
import org.qaddict.expectation.TransformedExpectation;
import org.qaddict.functions.Transformation;

public abstract class AbstractExpectationBuilder<T, D>
implements Expectation<D> {
    private final List<Expectation<? super D>> operands;
    private final OperatorExpectation<D> operator;

    public AbstractExpectationBuilder(List<Expectation<? super D>> operands) {
        this.operands = operands;
        this.operator = new OperatorExpectation(operands, OperatorExpectation.AND);
    }

    public AbstractExpectationBuilder() {
        this(new ArrayList<Expectation<? super D>>());
    }

    @Override
    public EvaluationNode evaluate(D data) {
        return this.operands.size() == 1 ? this.operands.getFirst().evaluate(data) : this.operator.evaluate(data);
    }

    @Override
    public Object description() {
        return this.operands.size() > 5 ? "Item to match " + this.operands.size() + " expectations" : this.operator.description();
    }

    public T and(Expectation<? super D> expectation) {
        this.operands.add(expectation);
        return this.self();
    }

    public <V> FluentTransformation<V, T> and(String name, Transformation<? super D, V> transformation) {
        return expectation -> this.and(new ExpectationDescription(name, new TransformedExpectation(transformation, expectation)));
    }

    public <V> FluentTransformation<V, T> and(Transformation<? super D, V> transformation) {
        return expectation -> this.and(new TransformedExpectation(transformation, expectation));
    }

    protected abstract T self();
}

