/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.expectation;

import java.util.ArrayList;
import java.util.List;
import org.qaddict.Expectation;
import org.qaddict.evaluation.EvaluationNode;
import org.qaddict.expectation.ExpectationDescription;
import org.qaddict.expectation.FluentTransformation;
import org.qaddict.expectation.OperatorExpectation;
import org.qaddict.expectation.TransformedExpectation;
import org.qaddict.functions.Transformation;

public class ExpectationBuilder<D>
implements Expectation<D> {
    private final List<Expectation<? super D>> operands;
    private final OperatorExpectation<D> operator;

    public ExpectationBuilder(List<Expectation<? super D>> operands) {
        this.operands = operands;
        this.operator = new OperatorExpectation(operands, OperatorExpectation.AND);
    }

    public ExpectationBuilder() {
        this(new ArrayList<Expectation<? super D>>());
    }

    @Override
    public EvaluationNode evaluate(D data) {
        return this.operands.size() == 1 ? this.operands.getFirst().evaluate(data) : this.operator.evaluate(data);
    }

    @Override
    public Object description() {
        return this.operands.size() > 5 ? "Item to match " + this.operands.size() + " expectations" : this.operator.description();
    }

    public <E extends D> ExpectationBuilder<E> and(Expectation<? super E> expectation) {
        ArrayList<Expectation<D>> o = new ArrayList<Expectation<D>>(this.operands);
        o.add(expectation);
        return new ExpectationBuilder<D>(o);
    }

    public <E extends D, V> FluentTransformation<V, ExpectationBuilder<E>> and(String name, Transformation<? super E, V> transformation) {
        return expectation -> this.and(new ExpectationDescription(name, new TransformedExpectation(transformation, expectation)));
    }

    public <E extends D, V> FluentTransformation<V, ExpectationBuilder<E>> and(Transformation<? super E, V> transformation) {
        return expectation -> this.and(new TransformedExpectation(transformation, expectation));
    }
}

