/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.expectation;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.qaddict.Described;
import org.qaddict.Expectation;
import org.qaddict.algo.MaximumMatching;
import org.qaddict.evaluation.ComposedNode;
import org.qaddict.evaluation.EvaluationNode;
import org.qaddict.evaluation.EvaluationNodes;
import org.qaddict.expectation.Mode;

public record InAnyOrderExpectation<D>(Collection<Expectation<? super D>> expectations, Mode mode) implements Expectation<Iterable<D>>
{
    @Override
    public EvaluationNode evaluate(Iterable<D> data) {
        if (data == null) {
            return EvaluationNodes.expectation(this, EvaluationNodes.result(false));
        }
        MaximumMatching<MaximumMatching.Node<D>, ComposedNode.Builder<D>> graph = new MaximumMatching<MaximumMatching.Node<D>, ComposedNode.Builder<D>>();
        List<ComposedNode.Builder<D>> evaluationBuilders = ComposedNode.buildersFor(this.expectations);
        Stream<D> stream = StreamSupport.stream(data.spliterator(), false);
        return EvaluationNodes.expectation(this, EvaluationNodes.compose(switch (this.mode) {
            default -> throw new MatchException(null, null);
            case Mode.EQUALS -> this.equals(stream, evaluationBuilders, graph);
            case Mode.CONTAINS -> this.contains(stream, evaluationBuilders, graph);
            case Mode.STARTS -> this.starts(stream, evaluationBuilders, graph);
        }, InAnyOrderExpectation.byPairing2(evaluationBuilders, graph)));
    }

    @Override
    public Object description() {
        return "collection " + String.valueOf((Object)this.mode) + " in order of definition " + String.valueOf(this.expectations().stream().map(Described::description).toList());
    }

    private boolean equals(Stream<D> data, List<ComposedNode.Builder<D>> evaluationBuilders, MaximumMatching<MaximumMatching.Node<D>, ComposedNode.Builder<D>> graph) {
        data.forEach(item -> InAnyOrderExpectation.update(item, evaluationBuilders, graph));
        return graph.pairing().size() == this.expectations.size() && graph.edges().size() == this.expectations.size();
    }

    private boolean contains(Stream<D> data, List<ComposedNode.Builder<D>> evaluationBuilders, MaximumMatching<MaximumMatching.Node<D>, ComposedNode.Builder<D>> graph) {
        return data.anyMatch(item -> InAnyOrderExpectation.update(item, evaluationBuilders, graph).size() == this.expectations.size());
    }

    private boolean starts(Stream<D> data, List<ComposedNode.Builder<D>> evaluationBuilders, MaximumMatching<MaximumMatching.Node<D>, ComposedNode.Builder<D>> graph) {
        return this.contains(data, evaluationBuilders, graph) && graph.edges().size() == this.expectations.size();
    }

    public static <D> Map<ComposedNode.Builder<D>, MaximumMatching.Node<D>> update(D item, Collection<ComposedNode.Builder<D>> expectations, MaximumMatching<MaximumMatching.Node<D>, ComposedNode.Builder<D>> graph) {
        return graph.update(MaximumMatching.node(item), expectations.stream().filter(e -> e.evaluate(item).result()).collect(Collectors.toList()));
    }

    private static <D> List<EvaluationNode> byPairing2(List<ComposedNode.Builder<D>> evaluationBuilders, MaximumMatching<MaximumMatching.Node<D>, ComposedNode.Builder<D>> graph) {
        return graph.free().isEmpty() ? InAnyOrderExpectation.byPairing(evaluationBuilders, graph) : Stream.concat(evaluationBuilders.stream().map(builder -> builder.build(graph.pairing().containsKey(builder))), Stream.of(EvaluationNodes.actualValue(graph.free().size() + " items", EvaluationNodes.expectation(Described.description("No extra items"), EvaluationNodes.result(false))))).collect(Collectors.toList());
    }

    public static <D> List<EvaluationNode> byPairing(List<ComposedNode.Builder<D>> evaluationBuilders, MaximumMatching<MaximumMatching.Node<D>, ComposedNode.Builder<D>> graph) {
        return evaluationBuilders.stream().map(builder -> builder.build(graph.pairing().containsKey(builder))).collect(Collectors.toList());
    }
}

