/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.expectation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.qaddict.Described;
import org.qaddict.Expectation;
import org.qaddict.evaluation.ComposedNode;
import org.qaddict.evaluation.EvaluationNode;
import org.qaddict.evaluation.EvaluationNodes;
import org.qaddict.expectation.Mode;

public record InOrderOfDefinitionExpectation<D>(Collection<Expectation<? super D>> expectations, Mode mode) implements Expectation<Iterable<D>>
{
    @Override
    public EvaluationNode evaluate(Iterable<D> data) {
        if (data == null) {
            return EvaluationNodes.expectation(this, EvaluationNodes.result(false));
        }
        Iterator<D> iterator = data.iterator();
        ComposedNode.Builder<Iterable<D>> builder = ComposedNode.builderFor(this);
        Stream<ComposedNode.Builder> stream = this.expectations.stream().map(ComposedNode::builderFor);
        return builder.build(switch (this.mode) {
            default -> throw new MatchException(null, null);
            case Mode.EQUALS -> this.equals(iterator, stream, builder);
            case Mode.CONTAINS -> this.contains(iterator, stream, builder);
            case Mode.STARTS -> this.starts(iterator, stream, builder);
        });
    }

    @Override
    public String description() {
        return "collection " + String.valueOf((Object)this.mode) + " in order of definition " + String.valueOf(this.expectations().stream().map(Described::description).toList());
    }

    private boolean equals(Iterator<D> iterator, Stream<? extends ComposedNode.Builder<D>> expectations, ComposedNode.Builder<Iterable<D>> builder) {
        return this.starts(iterator, expectations, builder) && (!iterator.hasNext() || builder.add(EvaluationNodes.expectation(Described.description("No extra items"), EvaluationNodes.actualValue(this.extraItems(iterator), EvaluationNodes.result(false)))).result());
    }

    private boolean starts(Iterator<D> iterator, Stream<? extends ComposedNode.Builder<D>> builders, ComposedNode.Builder<Iterable<D>> builder) {
        return builders.map(b -> builder.add((ComposedNode.Builder<?>)b, iterator.hasNext() && b.evaluate(iterator.next()).result())).reduce((l, r) -> l != false && r != false).orElse(true);
    }

    private boolean contains(Iterator<D> iterator, Stream<? extends ComposedNode.Builder<D>> expectations, ComposedNode.Builder<Iterable<D>> builder) {
        return expectations.allMatch(b -> builder.add((ComposedNode.Builder<?>)b, this.match((ComposedNode.Builder<D>)b, iterator)));
    }

    private boolean match(ComposedNode.Builder<D> expectation, Iterator<D> iterator) {
        while (iterator.hasNext()) {
            if (!expectation.evaluate(iterator.next()).result()) continue;
            return true;
        }
        return false;
    }

    private List<D> extraItems(Iterator<D> iterator) {
        return Stream.iterate(iterator, Iterator::hasNext, UnaryOperator.identity()).map(Iterator::next).toList();
    }
}

