/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.expectation;

import java.util.Collection;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.qaddict.Described;
import org.qaddict.Expectation;
import org.qaddict.evaluation.EvaluationNode;
import org.qaddict.evaluation.EvaluationNodes;

public record OperatorExpectation<D>(Collection<Expectation<? super D>> operands, BinaryOperator<Boolean> operator) implements Expectation<D>
{
    public static final BinaryOperator<Boolean> AND = (l, r) -> l != false && r != false;
    public static final BinaryOperator<Boolean> OR = (l, r) -> l != false || r != false;

    @Override
    public EvaluationNode evaluate(D data) {
        List<EvaluationNode> nodes = this.operands.stream().map(operand -> operand.evaluate(data)).collect(Collectors.toList());
        return EvaluationNodes.expectation(this, EvaluationNodes.compose(nodes.stream().map(EvaluationNode::result).reduce(this.operator).orElse(AND.equals(this.operator)), nodes));
    }

    @Override
    public Object description() {
        return this.operands.stream().map(Described::description).map(Object::toString).collect(Collectors.joining(this.operator == AND ? " and " : " or "));
    }
}

