/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.maven.run;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.qaddict.maven.run.ArgParser;
import org.qaddict.maven.run.JarKey;
import org.qaddict.starter.Jvm;

public abstract class AbstractRunnerMojo
extends AbstractMojo {
    @Component
    RepositorySystem system;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Parameter(property="in", readonly=true, required=true)
    String coordinates;
    @Parameter(property="args")
    String args;
    @Parameter(property="argFile")
    String argFile;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        List<String> resolvedArgs;
        if (this.coordinates == null) {
            throw new MojoFailureException("Artifact coordinates with code to execute not provided. Use the system property -Din=<coordinates>");
        }
        String[] parts = this.coordinates.split(":");
        if (parts.length != 3) {
            throw new MojoExecutionException("Invalid artifact coordinates: " + this.coordinates);
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(parts[0]);
        dependency.setArtifactId(parts[1]);
        dependency.setVersion(parts[2]);
        Artifact artifact = this.system.createDependencyArtifact(dependency);
        ArtifactResolutionResult result = this.system.resolve(new ArtifactResolutionRequest().setArtifact(artifact).setResolveTransitively(true).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.session.getRequest().getRemoteRepositories()).setManagedVersionMap(this.session.getCurrentProject().getManagedVersionMap()).setResolveRoot(true));
        if (result.hasMissingArtifacts()) {
            throw new MojoExecutionException("Unable to resolve dependencies: " + result.getMissingArtifacts());
        }
        if (result.hasExceptions()) {
            throw new MojoExecutionException("Errors occurred: " + result.getExceptions());
        }
        Set artifacts = result.getArtifacts();
        List<String> jars = artifacts.stream().map(a -> a.getFile().getPath()).toList();
        Map<String, String> artifactJars = artifacts.stream().flatMap(JarKey::keys).collect(Collectors.toMap(JarKey::key, JarKey::jar));
        try {
            resolvedArgs = (this.argFile == null ? ArgParser.parse(this.args) : Files.lines(Paths.get(this.argFile, new String[0]))).map(a -> artifactJars.getOrDefault(a, (String)a)).toList();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to parse file with arguments: " + this.argFile);
        }
        this.execute(Jvm.ofCurrent().classPath(jars), artifactJars.getOrDefault(this.coordinates, this.coordinates), new ArrayList<String>(resolvedArgs));
    }

    protected abstract void execute(Jvm var1, String var2, List<String> var3) throws MojoExecutionException;
}

