/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.maven.run;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Stream;

public class ArgParser {
    private ArgParser() {
    }

    public static Stream<String> parse(String commandLine) {
        if (commandLine == null) {
            return Stream.empty();
        }
        ArrayList<StringBuilder> result = new ArrayList<StringBuilder>();
        StringReader reader = new StringReader(commandLine);
        try {
            while (ArgParser.parseArg(reader, result)) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.stream().map(Object::toString);
    }

    private static boolean parseArg(StringReader input, List<StringBuilder> result) throws IOException {
        int c = input.read();
        while (c > 0) {
            if (!Character.isSpaceChar(c)) {
                switch (c) {
                    case 34: {
                        return ArgParser.parseValue(input.read(), input, result, i -> i == 34);
                    }
                    case 39: {
                        return ArgParser.parseValue(input.read(), input, result, i -> i == 39);
                    }
                }
                return ArgParser.parseValue(c, input, result, Character::isSpaceChar);
            }
            c = input.read();
        }
        return false;
    }

    private static boolean parseValue(int c, StringReader reader, List<StringBuilder> result, IntPredicate end) throws IOException {
        StringBuilder builder = new StringBuilder();
        result.add(builder);
        while (!end.test(c)) {
            if (c <= 0) {
                return false;
            }
            if (c == 92) {
                c = reader.read();
            }
            builder.append((char)c);
            c = reader.read();
        }
        return true;
    }
}

