/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.maven.run;

import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;

public record JarKey(String key, String jar) {
    public static JarKey of(String jar, String ... id) {
        return new JarKey(String.join((CharSequence)":", id), jar);
    }

    public static Stream<JarKey> keys(Artifact artifact) {
        String absolutePath = artifact.getFile().getAbsolutePath();
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        String type = artifact.getType();
        String classifier = artifact.getClassifier();
        return classifier == null ? Stream.of(JarKey.of(absolutePath, groupId, artifactId, version, type), JarKey.of(absolutePath, groupId, artifactId, version), JarKey.of(absolutePath, groupId, artifactId), JarKey.of(absolutePath, groupId, artifactId, type)) : Stream.of(JarKey.of(absolutePath, groupId, artifactId, classifier, version, type), JarKey.of(absolutePath, groupId, artifactId, classifier, type));
    }
}

