/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.finiteState.lazy;

import java.util.HashSet;
import java.util.Set;
import org.qenherkhopeshef.finiteState.lazy.AbstractMultiState;
import org.qenherkhopeshef.finiteState.lazy.MultiStateIF;
import org.qenherkhopeshef.finiteState.lazy.RegularLanguageIF;

class ComplementLanguage<T>
implements RegularLanguageIF<T> {
    private final RegularLanguageIF<T> complemented;

    public ComplementLanguage(RegularLanguageIF<T> negated) {
        this.complemented = negated;
    }

    @Override
    public Set<? extends MultiStateIF<T>> getInitialStates() {
        HashSet<ComplementState> result = new HashSet<ComplementState>();
        Set<MultiStateIF<T>> newChildren = this.complemented.getInitialStates();
        result.add(new ComplementState(newChildren));
        return result;
    }

    public String toString() {
        return "[~ " + this.complemented + "]";
    }

    private static boolean containsTerminal(Set<? extends MultiStateIF<?>> states) {
        boolean hasTerminal = false;
        for (MultiStateIF<?> newChild : states) {
            if (!newChild.isTerminal()) continue;
            hasTerminal = true;
            break;
        }
        return hasTerminal;
    }

    private class ComplementState
    extends AbstractMultiState<T> {
        private final Set<? extends MultiStateIF<T>> complementedStates;

        public ComplementState(Set<? extends MultiStateIF<T>> complementedStates) {
            super(!ComplementLanguage.containsTerminal(complementedStates));
            this.complementedStates = complementedStates;
        }

        @Override
        public Set<ComplementState> accept(T token) {
            HashSet<ComplementState> result = new HashSet<ComplementState>();
            HashSet newChildren = new HashSet();
            for (MultiStateIF childState : this.complementedStates) {
                newChildren.addAll(childState.accept(token));
            }
            result.add(new ComplementState(newChildren));
            return result;
        }

        @Override
        public RegularLanguageIF<T> getParent() {
            return ComplementLanguage.this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ComplementState) {
                ComplementState other = (ComplementState)obj;
                return this.getParent().equals(other.getParent()) && this.terminal == other.terminal && this.complementedStates.equals(other.complementedStates);
            }
            return false;
        }

        public int hashCode() {
            return this.getParent().hashCode() + 31 * this.complementedStates.hashCode();
        }

        public String toString() {
            return "(~" + this.complementedStates + ")";
        }
    }
}

