/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.finiteState.lazy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.qenherkhopeshef.finiteState.lazy.AbstractMultiState;
import org.qenherkhopeshef.finiteState.lazy.CompositeLanguage;
import org.qenherkhopeshef.finiteState.lazy.MultiStateIF;
import org.qenherkhopeshef.finiteState.lazy.RegularLanguageIF;

class IntersectionLanguage<T>
extends CompositeLanguage<T> {
    public IntersectionLanguage(List<? extends RegularLanguageIF<T>> children) {
        super(children);
    }

    @Override
    public Set<? extends MultiStateIF<T>> getInitialStates() {
        ArrayList<ArrayList<MultiStateIF<T>>> allStates = new ArrayList<ArrayList<MultiStateIF<T>>>();
        for (int i = 0; i < this.getChildren().size(); ++i) {
            allStates.add(new ArrayList(this.getChildren().get(i).getInitialStates()));
        }
        Set<IntersectionState> result = this.combineStates(allStates);
        return result;
    }

    private Set<IntersectionState> combineStates(ArrayList<ArrayList<MultiStateIF<T>>> allStates) {
        HashSet<IntersectionState> result = new HashSet<IntersectionState>();
        for (int i = 0; i < allStates.size(); ++i) {
            if (!allStates.get(i).isEmpty()) continue;
            return result;
        }
        int[] indexes = new int[this.getChildren().size()];
        while (this.notLastIndex(indexes, allStates)) {
            ArrayList newChildState = new ArrayList();
            for (int i = 0; i < indexes.length; ++i) {
                newChildState.add(allStates.get(i).get(indexes[i]));
            }
            result.add(new IntersectionState(newChildState));
            this.nextIndex(indexes, allStates);
        }
        return result;
    }

    private void nextIndex(int[] indexes, ArrayList<ArrayList<MultiStateIF<T>>> allStates) {
        int i;
        for (i = indexes.length - 1; i >= 0 && indexes[i] >= allStates.get(i).size() - 1; --i) {
        }
        if (i == -1) {
            Arrays.fill(indexes, 0);
            indexes[0] = allStates.get(0).size();
        } else {
            int n = i;
            indexes[n] = indexes[n] + 1;
            Arrays.fill(indexes, i + 1, indexes.length, 0);
        }
    }

    private boolean notLastIndex(int[] indexes, ArrayList<ArrayList<MultiStateIF<T>>> allStates) {
        return indexes[0] != allStates.get(0).size();
    }

    public String toString() {
        return "[Intersection " + this.getChildren() + "]";
    }

    class IntersectionState
    extends AbstractMultiState<T> {
        private final List<MultiStateIF<T>> childrenStates;

        public IntersectionState(List<MultiStateIF<T>> childrenStates) {
            super(true);
            this.childrenStates = childrenStates;
            for (MultiStateIF c : childrenStates) {
                if (c.isTerminal()) continue;
                this.terminal = false;
            }
        }

        @Override
        public Set<IntersectionState> accept(T token) {
            ArrayList allStates = new ArrayList();
            for (int i = 0; i < this.childrenStates.size(); ++i) {
                allStates.add(new ArrayList(this.childrenStates.get(i).accept(token)));
            }
            Set result = IntersectionLanguage.this.combineStates(allStates);
            return result;
        }

        @Override
        public RegularLanguageIF<T> getParent() {
            return IntersectionLanguage.this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IntersectionState) {
                IntersectionState state = (IntersectionState)obj;
                if (!this.getParent().equals(state.getParent())) {
                    return false;
                }
                boolean result = this.childrenStates.equals(state.childrenStates);
                return result;
            }
            return false;
        }

        public int hashCode() {
            return this.childrenStates.hashCode() + 31 * this.getParent().hashCode();
        }

        public String toString() {
            return "(Inter " + this.childrenStates + ")";
        }
    }
}

