/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.finiteState.lazy;

import java.util.HashSet;
import java.util.Set;
import org.qenherkhopeshef.finiteState.lazy.MultiStateIF;
import org.qenherkhopeshef.finiteState.lazy.RegularLanguageIF;
import org.qenherkhopeshef.finiteState.lazy.SingleChildState;

class KleeneStarLanguage<T>
implements RegularLanguageIF<T> {
    private final RegularLanguageIF<T> repeatedAutomaton;

    public KleeneStarLanguage(RegularLanguageIF<T> repeatedAutomaton) {
        this.repeatedAutomaton = repeatedAutomaton;
    }

    @Override
    public Set<? extends MultiStateIF<T>> getInitialStates() {
        HashSet<RepeatAutomatonState> result = new HashSet<RepeatAutomatonState>();
        for (MultiStateIF<T> m : this.repeatedAutomaton.getInitialStates()) {
            result.add(new RepeatAutomatonState(m, true));
        }
        return result;
    }

    public String toString() {
        return "[STAR" + this.repeatedAutomaton.toString() + "]";
    }

    private class RepeatAutomatonState
    extends SingleChildState<T> {
        public RepeatAutomatonState(MultiStateIF<T> childState, boolean terminal) {
            super(childState, terminal);
        }

        @Override
        public Set<? extends MultiStateIF<T>> accept(T token) {
            HashSet result = new HashSet();
            boolean hasInitial = false;
            for (MultiStateIF newChildstate : this.childState.accept(token)) {
                result.add(new RepeatAutomatonState(newChildstate, newChildstate.isTerminal()));
                if (!newChildstate.isTerminal() || hasInitial) continue;
                result.addAll(KleeneStarLanguage.this.getInitialStates());
                hasInitial = true;
            }
            return result;
        }

        @Override
        public RegularLanguageIF<T> getParent() {
            return KleeneStarLanguage.this;
        }

        public String toString() {
            return "(STAR " + this.childState + ")";
        }
    }
}

