/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.finiteState.lazy;

import java.util.Collections;
import java.util.Set;
import org.qenherkhopeshef.finiteState.lazy.LazyLabelIF;
import org.qenherkhopeshef.finiteState.lazy.MultiStateIF;
import org.qenherkhopeshef.finiteState.lazy.RegularLanguageIF;

class LabelLanguage<T>
implements RegularLanguageIF<T> {
    private final LazyLabelIF<T> label;

    public LabelLanguage(LazyLabelIF<T> label) {
        this.label = label;
    }

    @Override
    public Set<? extends MultiStateIF<T>> getInitialStates() {
        return Collections.singleton(new TokenAutomatonState(0));
    }

    public String toString() {
        return this.label.toString();
    }

    class TokenAutomatonState
    implements MultiStateIF<T> {
        private short state = 0;

        public TokenAutomatonState(short state) {
            this.state = state;
        }

        @Override
        public boolean isTerminal() {
            return this.state == 1;
        }

        @Override
        public Set<? extends MultiStateIF<T>> accept(T token) {
            short out = 2;
            if (this.state == 0 && LabelLanguage.this.label.matches(token)) {
                out = 1;
            }
            return Collections.singleton(new TokenAutomatonState(out));
        }

        @Override
        public RegularLanguageIF<T> getParent() {
            return LabelLanguage.this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TokenAutomatonState) {
                TokenAutomatonState other = (TokenAutomatonState)obj;
                return this.getParent().equals(other.getParent()) && this.state == other.state;
            }
            return false;
        }

        public int hashCode() {
            return this.getParent().hashCode() + 31 * this.state;
        }

        public String toString() {
            String[] s = new String[]{"start", "ok", "bad"};
            return "(label " + LabelLanguage.this.label.toString() + s[this.state] + ")";
        }
    }
}

