/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.finiteState.lazy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.qenherkhopeshef.finiteState.lazy.RegularLanguageFactory;
import org.qenherkhopeshef.finiteState.lazy.RegularLanguageIF;
import org.qenherkhopeshef.finiteState.lazy.ReportingLanguageRecognizer;

public class RegularExtractor<T> {
    private final List<RegularLanguageIF<T>> language;
    private final int postContextSize;

    public RegularExtractor(List<RegularLanguageIF<T>> parts) {
        this.language = new ArrayList<RegularLanguageIF<T>>(parts);
        this.postContextSize = 0;
    }

    public RegularExtractor(RegularLanguageIF<T> ... parts) {
        this.language = new ArrayList<RegularLanguageIF<T>>(Arrays.asList(parts));
        this.postContextSize = 0;
    }

    private RegularExtractor(List<RegularLanguageIF<T>> parts, int postContextSize) {
        this.language = new ArrayList<RegularLanguageIF<T>>(parts);
        this.postContextSize = postContextSize;
    }

    public static <T> RegularExtractor<T> buildRegularExtractorWithPostContext(List<RegularLanguageIF<T>> mainLanguage, List<RegularLanguageIF<T>> postContext) {
        ArrayList<RegularLanguageIF<T>> allParts = new ArrayList<RegularLanguageIF<T>>(mainLanguage);
        allParts.addAll(postContext);
        return new RegularExtractor<T>(allParts, postContext.size());
    }

    public List<List<Integer>> search(List<T> input) {
        boolean ok;
        ArrayList toMatch = new ArrayList();
        toMatch.add(RegularLanguageFactory.skip());
        toMatch.addAll(this.language);
        ReportingLanguageRecognizer<T> aux = new ReportingLanguageRecognizer<T>(toMatch);
        aux.setEarlyStop(true);
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        int pos = 0;
        do {
            if (!(ok = aux.recognize(pos, input))) continue;
            List<Integer> positions = aux.getMarkers();
            result.add(positions.subList(0, positions.size() - this.postContextSize));
            pos = positions.get(positions.size() - 1 - this.postContextSize);
        } while (ok);
        return result;
    }

    public Optional<List<Integer>> recognizesBeginning(List<T> tokens) {
        if (this.postContextSize != 0) {
            throw new IllegalStateException("method not supported with post context");
        }
        ReportingLanguageRecognizer<T> aux = new ReportingLanguageRecognizer<T>(this.language);
        aux.setEarlyStop(true);
        boolean ok = aux.recognize(tokens);
        if (ok) {
            return Optional.of(aux.getMarkers());
        }
        return Optional.empty();
    }

    public Optional<List<Integer>> recognizesAll(List<T> tokens) {
        if (this.postContextSize != 0) {
            throw new IllegalStateException("method not supported with post context");
        }
        ReportingLanguageRecognizer<T> aux = new ReportingLanguageRecognizer<T>(this.language);
        aux.setEarlyStop(false);
        boolean ok = aux.recognize(tokens);
        if (ok) {
            return Optional.of(aux.getMarkers());
        }
        return Optional.empty();
    }

    public static <T> Builder<T> getBuilder(RegularLanguageIF<T> l0) {
        return new Builder<T>().part(l0);
    }

    public static <T> Builder<T> getBuilder() {
        return new Builder();
    }

    public static class Builder<T> {
        private final ArrayList<RegularLanguageIF<T>> languages = new ArrayList();

        Builder() {
        }

        public Builder<T> part(RegularLanguageIF<T> l) {
            this.languages.add(l);
            return this;
        }

        public RegularExtractor<T> build() {
            return new RegularExtractor<T>(this.languages);
        }
    }
}

