/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.finiteState.lazy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.qenherkhopeshef.finiteState.lazy.AnyTokenLabel;
import org.qenherkhopeshef.finiteState.lazy.ComplementLabel;
import org.qenherkhopeshef.finiteState.lazy.ComplementLanguage;
import org.qenherkhopeshef.finiteState.lazy.EmptyLanguage;
import org.qenherkhopeshef.finiteState.lazy.EmptyStringLanguage;
import org.qenherkhopeshef.finiteState.lazy.IntersectionLanguage;
import org.qenherkhopeshef.finiteState.lazy.KleeneStarLanguage;
import org.qenherkhopeshef.finiteState.lazy.LabelLanguage;
import org.qenherkhopeshef.finiteState.lazy.LazyLabelIF;
import org.qenherkhopeshef.finiteState.lazy.OutOfRangeLabel;
import org.qenherkhopeshef.finiteState.lazy.RangeLabel;
import org.qenherkhopeshef.finiteState.lazy.RegularLanguageIF;
import org.qenherkhopeshef.finiteState.lazy.SequenceLanguage;
import org.qenherkhopeshef.finiteState.lazy.SetLabel;
import org.qenherkhopeshef.finiteState.lazy.SimpleLabel;
import org.qenherkhopeshef.finiteState.lazy.UnionLanguage;

public final class RegularLanguageFactory {
    private RegularLanguageFactory() {
    }

    public static <T> RegularLanguageIF<T> seq(RegularLanguageIF<T> ... elts) {
        return RegularLanguageFactory.seq(Arrays.asList(elts));
    }

    public static <T> RegularLanguageIF<T> seq(List<RegularLanguageIF<T>> elts) {
        return new SequenceLanguage<T>(new ArrayList<RegularLanguageIF<T>>(elts));
    }

    public static <T> RegularLanguageIF<T> union(RegularLanguageIF<T> ... elts) {
        return RegularLanguageFactory.union(Arrays.asList(elts));
    }

    public static <T> RegularLanguageIF<T> union(Collection<RegularLanguageIF<T>> elts) {
        return new UnionLanguage<T>(new ArrayList<RegularLanguageIF<T>>(elts));
    }

    public static <T> RegularLanguageIF<T> star(RegularLanguageIF<T> l) {
        return new KleeneStarLanguage<T>(l);
    }

    public static <T> RegularLanguageIF<T> plus(RegularLanguageIF<T> l) {
        return RegularLanguageFactory.seq(l, RegularLanguageFactory.star(l));
    }

    public static <T> RegularLanguageIF<T> inter(Collection<RegularLanguageIF<T>> l) {
        return new IntersectionLanguage<T>(new ArrayList<RegularLanguageIF<T>>(l));
    }

    public static <T> RegularLanguageIF<T> inter(RegularLanguageIF<T> ... l) {
        return new IntersectionLanguage<T>(Arrays.asList(l));
    }

    public static <T> RegularLanguageIF<T> complement(RegularLanguageIF<T> lang) {
        return new ComplementLanguage<T>(lang);
    }

    public static <T> RegularLanguageIF<T> emptyLanguage() {
        return new EmptyLanguage();
    }

    public static <T> RegularLanguageIF<T> emptySequence() {
        return new EmptyStringLanguage();
    }

    public static <T> RegularLanguageIF<T> any() {
        return new LabelLanguage(new AnyTokenLabel());
    }

    public static <T> RegularLanguageIF<T> label(LazyLabelIF<T> label) {
        return new LabelLanguage<T>(label);
    }

    public static <T> RegularLanguageIF<T> exact(T token) {
        return new LabelLanguage<T>(new SimpleLabel<T>(token));
    }

    public static <T> RegularLanguageIF<T> different(T notThisToken) {
        return new LabelLanguage<T>(new ComplementLabel<T>(new SimpleLabel<T>(notThisToken)));
    }

    public static <T> RegularLanguageIF<T> inSet(Set<T> set) {
        return new LabelLanguage<T>(new SetLabel<T>(set));
    }

    public static <T> RegularLanguageIF<T> notInSet(Set<T> set) {
        return new LabelLanguage<T>(new ComplementLabel<T>(new SetLabel<T>(set)));
    }

    public static <T extends Comparable<T>> RegularLanguageIF<T> range(T low, T high) {
        return new LabelLanguage<T>(new RangeLabel<T>(low, high));
    }

    public static <T extends Comparable<T>> RegularLanguageIF<T> outOfRange(T low, T high) {
        return new LabelLanguage<T>(new OutOfRangeLabel<T>(low, high));
    }

    public static <T> RegularLanguageIF<T> skip() {
        return new KleeneStarLanguage<T>(RegularLanguageFactory.any());
    }

    public static <T> RegularLanguageIF<T> opt(RegularLanguageIF<T> l) {
        return RegularLanguageFactory.union(RegularLanguageFactory.emptySequence(), l);
    }

    public static <T> RegularLanguageIF<T> maxLength(RegularLanguageIF<T> l, int maxLength) {
        if (maxLength == 0) {
            return l;
        }
        return RegularLanguageFactory.inter(l, RegularLanguageFactory.maxLength(maxLength));
    }

    public static <T> RegularLanguageIF<T> maxLength(int maxLength) {
        ArrayList<RegularLanguageIF<T>> res = new ArrayList<RegularLanguageIF<T>>();
        for (int i = 0; i <= maxLength; ++i) {
            res.add(RegularLanguageFactory.exactLength(i));
        }
        return RegularLanguageFactory.union(res);
    }

    public static <T> RegularLanguageIF<T> exactLength(int length) {
        if (length == 0) {
            return RegularLanguageFactory.emptySequence();
        }
        ArrayList<RegularLanguageIF<T>> res = new ArrayList<RegularLanguageIF<T>>();
        for (int i = 0; i < length; ++i) {
            res.add(RegularLanguageFactory.any());
        }
        return RegularLanguageFactory.seq(res);
    }
}

