/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.finiteState.lazy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qenherkhopeshef.finiteState.lazy.RegularLanguageIF;
import org.qenherkhopeshef.finiteState.lazy.SequenceLanguage;

class ReportingLanguageRecognizer<T> {
    private final SequenceLanguage<T> sequenceLanguage;
    private List<Integer> markers = null;
    private boolean terminal;
    private boolean earlyStop = true;

    public ReportingLanguageRecognizer(List<RegularLanguageIF<T>> regularLanguage) {
        this.sequenceLanguage = new SequenceLanguage<T>(new ArrayList<RegularLanguageIF<T>>(regularLanguage));
    }

    public ReportingLanguageRecognizer(RegularLanguageIF<T> ... languages) {
        List<RegularLanguageIF<T>> l = Arrays.asList(languages);
        this.sequenceLanguage = new SequenceLanguage<T>(l);
    }

    public void setEarlyStop(boolean earlyStop) {
        this.earlyStop = earlyStop;
    }

    public boolean isEarlyStop() {
        return this.earlyStop;
    }

    public boolean recognize(List<T> tokens) {
        return this.recognize(0, tokens);
    }

    public boolean recognize(int startPos, List<T> tokens) {
        this.markers = null;
        this.terminal = false;
        MarkedState currentState = new MarkedState(this.sequenceLanguage.getInitialStates(), startPos);
        for (int pos = startPos; !(pos >= tokens.size() || this.terminal && this.earlyStop); ++pos) {
            T token = tokens.get(pos);
            currentState = this.accept(currentState, token, pos + 1);
        }
        if (this.terminal) {
            SequenceLanguage.SequenceState best = null;
            List bestMark = null;
            for (Map.Entry<SequenceLanguage.SequenceState, ArrayList<Integer>> entry : currentState.markerMap.entrySet()) {
                if (!entry.getKey().isTerminal() || best != null && !ReportingLanguageRecognizer.isBetterMark((List<Integer>)entry.getValue(), bestMark)) continue;
                best = entry.getKey();
                bestMark = entry.getValue();
            }
            this.markers = bestMark;
        }
        return this.terminal;
    }

    private MarkedState accept(MarkedState current, T token, int pos) {
        MarkedState next = new MarkedState();
        for (SequenceLanguage.SequenceState currentState : current.children) {
            ArrayList<Integer> currentStateMarker = current.getMarker(currentState);
            for (SequenceLanguage.SequenceState nextState : currentState.accept(token)) {
                next.addState(currentState, nextState, currentStateMarker, pos);
            }
        }
        return next;
    }

    public int endingPosition() {
        if (this.markers == null) {
            return -1;
        }
        return this.markers.get(this.markers.size() - 1);
    }

    public List<Integer> getMarkers() {
        if (this.markers != null) {
            return new ArrayList<Integer>(this.markers);
        }
        return null;
    }

    private static boolean isBetterMark(List<Integer> marker1, List<Integer> marker2) {
        int i;
        int l = Math.min(marker1.size(), marker2.size());
        for (i = 0; i < l && marker1.get(i).equals(marker2.get(i)); ++i) {
        }
        if (i == l) {
            return marker1.size() < marker2.size();
        }
        return marker1.get(i) < marker2.get(i);
    }

    private class MarkedState {
        public HashMap<SequenceLanguage.SequenceState, ArrayList<Integer>> markerMap = new HashMap();
        public Set<SequenceLanguage.SequenceState> children = new HashSet<SequenceLanguage.SequenceState>();

        public MarkedState(Set<SequenceLanguage.SequenceState> children) {
            ArrayList<Integer> emptyList = new ArrayList<Integer>();
            for (SequenceLanguage.SequenceState child : children) {
                this.addState(null, child, emptyList, 0);
            }
        }

        public MarkedState(Set<SequenceLanguage.SequenceState> children, int initialPosition) {
            ArrayList<Integer> emptyList = new ArrayList<Integer>();
            for (SequenceLanguage.SequenceState child : children) {
                this.addState(null, child, emptyList, initialPosition);
            }
        }

        private void addState(SequenceLanguage.SequenceState previousState, SequenceLanguage.SequenceState childState, ArrayList<Integer> previousMarkers, int pos) {
            ArrayList<Integer> nextStateMarker;
            this.children.add(childState);
            if (childState.isTerminal()) {
                ReportingLanguageRecognizer.this.terminal = true;
            }
            int previousLanguageIndex = -1;
            if (previousState != null) {
                previousLanguageIndex = previousState.getChildIndex();
            }
            if (previousLanguageIndex == childState.getChildIndex() && !childState.isTerminalForSubLanguage()) {
                nextStateMarker = previousMarkers;
            } else {
                int markerSize = childState.isTerminalForSubLanguage() ? childState.getChildIndex() + 1 : childState.getChildIndex();
                nextStateMarker = new ArrayList<Integer>(previousMarkers);
                while (nextStateMarker.size() < markerSize) {
                    nextStateMarker.add(pos);
                }
                if (previousLanguageIndex >= 0 && previousLanguageIndex < childState.getChildIndex()) {
                    nextStateMarker.set(previousLanguageIndex, pos);
                }
                if (childState.isTerminalForSubLanguage()) {
                    nextStateMarker.set(childState.getChildIndex(), pos);
                }
            }
            if (!this.markerMap.containsKey(childState) || ReportingLanguageRecognizer.isBetterMark(nextStateMarker, this.getMarker(childState))) {
                this.markerMap.put(childState, nextStateMarker);
            }
        }

        public MarkedState() {
        }

        public ArrayList<Integer> getMarker(SequenceLanguage.SequenceState currentState) {
            return this.markerMap.get(currentState);
        }
    }
}

