/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.finiteState.lazy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.qenherkhopeshef.finiteState.lazy.AbstractMultiState;
import org.qenherkhopeshef.finiteState.lazy.CompositeLanguage;
import org.qenherkhopeshef.finiteState.lazy.EmptyStringLanguage;
import org.qenherkhopeshef.finiteState.lazy.MultiStateIF;
import org.qenherkhopeshef.finiteState.lazy.RegularLanguageIF;

class SequenceLanguage<T>
extends CompositeLanguage<T> {
    public SequenceLanguage(List<? extends RegularLanguageIF<T>> children) {
        super(children.isEmpty() ? Collections.singletonList(new EmptyStringLanguage()) : children);
    }

    @Override
    public Set<SequenceState> getInitialStates() {
        return this.statesStartingAt(0);
    }

    private Set<SequenceState> statesStartingAt(int childIndex) {
        HashSet<SequenceState> result = new HashSet<SequenceState>();
        boolean nextReachable = true;
        while (nextReachable && childIndex < this.getChildren().size()) {
            nextReachable = false;
            for (MultiStateIF s : this.getChildren().get(childIndex).getInitialStates()) {
                result.add(new SequenceState(childIndex, s));
                if (!s.isTerminal()) continue;
                nextReachable = true;
            }
            ++childIndex;
        }
        return result;
    }

    public String toString() {
        return "[S " + this.getChildren().toString() + "]";
    }

    public class SequenceState
    extends AbstractMultiState<T> {
        private final int childIndex;
        private final MultiStateIF<T> childState;

        SequenceState(int childIndex, MultiStateIF<T> childState) {
            super(childState.isTerminal() && childIndex == SequenceLanguage.this.getChildren().size() - 1);
            this.childIndex = childIndex;
            this.childState = childState;
        }

        public int getChildIndex() {
            return this.childIndex;
        }

        @Override
        public Set<SequenceState> accept(T token) {
            HashSet<SequenceState> result = new HashSet<SequenceState>();
            Set outStates = this.childState.accept(token);
            for (MultiStateIF childState : outStates) {
                if (childState.isTerminal()) {
                    result.addAll(SequenceLanguage.this.statesStartingAt(this.childIndex + 1));
                }
                result.add(new SequenceState(this.childIndex, childState));
            }
            return result;
        }

        @Override
        public boolean isTerminal() {
            return this.childIndex == SequenceLanguage.this.getChildren().size() - 1 && this.childState.isTerminal();
        }

        public boolean isTerminalForSubLanguage() {
            return this.childState.isTerminal();
        }

        public boolean equals(Object o) {
            if (o instanceof SequenceState) {
                SequenceState s = (SequenceState)o;
                return this.getParent() == s.getParent() && this.childIndex == s.childIndex && this.childState.equals(s.childState);
            }
            return false;
        }

        public int hashCode() {
            return this.childIndex + 31 * this.childState.hashCode() + 961 * this.getParent().hashCode();
        }

        @Override
        public RegularLanguageIF<T> getParent() {
            return SequenceLanguage.this;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("(state ");
            for (int i = 0; i < SequenceLanguage.this.getChildren().size(); ++i) {
                if (i == this.childIndex) {
                    result.append("[");
                    result.append(this.childState);
                    result.append("]");
                    if (!this.childState.isTerminal()) continue;
                    result.append("*");
                    continue;
                }
                result.append(SequenceLanguage.this.getChildren().get(i).toString());
                result.append(" ");
            }
            result.append(")");
            return result.toString();
        }
    }
}

