/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.finiteState.lazy;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.qenherkhopeshef.finiteState.lazy.CompositeLanguage;
import org.qenherkhopeshef.finiteState.lazy.MultiStateIF;
import org.qenherkhopeshef.finiteState.lazy.RegularLanguageIF;
import org.qenherkhopeshef.finiteState.lazy.SingleChildState;

class UnionLanguage<T>
extends CompositeLanguage<T> {
    public UnionLanguage(List<RegularLanguageIF<T>> children) {
        super(children);
    }

    @Override
    public Set<? extends MultiStateIF<T>> getInitialStates() {
        HashSet<UnionState> result = new HashSet<UnionState>();
        for (RegularLanguageIF subLang : this.getChildren()) {
            Set childStates = subLang.getInitialStates();
            for (MultiStateIF childState : childStates) {
                result.add(new UnionState(childState, childState.isTerminal()));
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        boolean first = true;
        for (RegularLanguageIF l : this.getChildren()) {
            if (!first) {
                buff.append(" |\u00a0");
            }
            buff.append(l);
            first = false;
        }
        return buff.toString();
    }

    private class UnionState
    extends SingleChildState<T> {
        public UnionState(MultiStateIF<T> childState, boolean terminal) {
            super(childState, terminal);
        }

        @Override
        public Set<UnionState> accept(T token) {
            HashSet<UnionState> result = new HashSet<UnionState>();
            for (MultiStateIF nextChildState : this.childState.accept(token)) {
                result.add(new UnionState(nextChildState, nextChildState.isTerminal()));
            }
            return result;
        }

        public String toString() {
            return "[U " + this.childState.toString() + "]";
        }

        @Override
        public RegularLanguageIF<T> getParent() {
            return UnionLanguage.this;
        }
    }
}

