/**
 * author : Serge ROSMORDUC
 * This file is distributed according to the LGPL (GNU lesser public license)
 */
package org.qenherkhopeshef.graphics.pict;

/**
 * Collection of OpCodes used in mac pict binary pictures (version 2).
 * <p> See Appendix A of the macintosh documentation.
 */
public interface MacPictOpcodes {
	int NOP= 0;
	int CLIP=1;
	int BK_PAT= 2;
	int TX_FONT= 3;
	int TX_FACE= 4;
	int TX_MODE= 5;
	int SP_EXTRA = 6;
	int PN_SIZE= 7;
	int PN_MODE=8;
	int PN_PATTERN=9;
	int FILL_PATH= 0x0A;
	int OV_SIZE= 0x0B;
	int ORIGIN= 0xC;
	int TX_SIZE= 0xD;
	int FG_COLOR= 0xE;
	int BK_COLOR= 0xF;
	int TX_RATIO= 0x10;
	int VERSION_OP= 0x11;
	int BK_PIX_PAT= 0x12;
	int PN_PIX_PAT= 0x13;
	int FILL_PIX_PAT= 0x14;
	int PN_LOC_H_FRAC= 0x15;
	int CH_EXTRA= 0x16;
	int RGB_FG_COL= 0x1A;
	int RGB_BK_COL= 0x1B;
	int HILITE_MODE= 0X001C;
	int HILITE_COLOR= 0X001D;
	int DEF_HILITE= 0X001E;
	int OP_COLOR= 0X001F;
	int LINE= 0X0020;
	int LINE_FROM= 0X0021;
	int SHORT_LINE= 0X0022;
	int SHORT_LINE_FROM= 0X0023;
	int LONG_TEXT= 0X0028;
	int DH_TEXT= 0X0029;
	int DV_TEXT= 0X002A;
	int DHDV_TEXT= 0X002B;
	int FONT_NAME= 0X002C;
	int LINE_JUSTIFY= 0X002D;
	int GLYPH_STATE= 0X002E;
	int FRAME_RECT= 0X0030;
	int PAINT_RECT= 0X0031;
	int ERASE_RECT= 0X0032;
	int INVERT_RECT= 0X0033;
	int FILL_RECT= 0X0034;
	int FRAME_SAME_RECT= 0X0038;
	int PAINT_SAME_RECT= 0X0039;
	int ERASE_SAME_RECT= 0X003A;
	int INVERT_SAME_RECT= 0X003B;
	int FILL_SAME_RECT= 0X003C;
	int FRAME_RRECT= 0X0040;
	int PAINT_RRECT= 0X0041;
	int ERASE_RRECT= 0X0042;
	int INVERT_RRECT= 0X0043;
	int FILL_RRECT= 0X0044;
	int FRAME_SAME_RRECT= 0X0048;
	int PAINT_SAME_RRECT= 0X0049;
	int ERASE_SAME_RRECT= 0X004A;
	int INVERT_SAME_RRECT= 0X004B;
	int FILL_SAME_RRECT= 0X004C;
	int FRAME_OVAL= 0X0050;
	int PAINT_OVAL= 0X0051;
	int ERASE_OVAL= 0X0052;
	int INVERT_OVAL= 0X0053;
	int FILL_OVAL= 0X0054;
	int FRAME_SAME_OVAL= 0X0058;
	int PAINT_SAME_OVAL= 0X0059;
	int ERASE_SAME_OVAL= 0X005A;
	int INVERT_SAME_OVAL= 0X005B;
	int FILL_SAME_OVAL= 0X005C;
	int FRAME_ARC= 0X0060;
	int PAINT_ARC= 0X0061;
	int ERASE_ARC= 0X0062;
	int INVERT_ARC= 0X0063;
	int FILL_ARC= 0X0064;
	int FRAME_SAME_ARC= 0X0068;
	int PAINT_SAME_ARC= 0X0069;
	int ERASE_SAME_ARC= 0X006A;
	int INVERT_SAME_ARC= 0X006B;
	int FILL_SAME_ARC= 0X006C;
	int FRAME_POLY= 0X0070;
	int PAINT_POLY= 0X0071;
	int ERASE_POLY= 0X0072;
	int INVERT_POLY= 0X0073;
	int FILL_POLY= 0X0074;
	int FRAME_SAME_POLY= 0X0078;
	int PAINT_SAME_POLY= 0X0079;
	int ERASE_SAME_POLY= 0X007A;
	int INVERT_SAME_POLY= 0X007B;
	int FILL_SAME_POLY= 0X007C;
	int FRAME_RGN= 0X0080;
	int PAINT_RGN= 0X0081;
	int ERASE_RGN= 0X0082;
	int INVERT_RGN= 0X0083;
	int FILL_RGN= 0X0084;
	int FRAME_SAME_RGN= 0X0088;
	int PAINT_SAME_RGN= 0X0089;
	int ERASE_SAME_RGN= 0X008A;
	int INVERT_SAME_RGN= 0X008B;
	int FILL_SAME_RGN= 0X008C;
	int BITS_RECT= 0X0090;
	int BITS_RGN= 0X0091;
	int PACK_BITS_RECT= 0X0098;
	int PACK_BITS_RGN= 0X0099;
	int DIRECT_BITS_RECT= 0X009A;
	int DIRECT_BITS_RGN= 0X009B;
	int SHORT_COMMENT= 0X00A0;
	int LONG_COMMENT= 0X00A1;
	int OP_END_PIC= 0X00FF;
	int VERSION= 0X02FF;
	int HEADER_OP= 0X0C00;
	int COMPRESSED_QUICKTIME= 0X8200;
	int UNCOMPRESSED_QUICKTIME= 0X8201;
}
