/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.solr.internal;

import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.qi4j.api.common.Optional;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.api.query.grammar.QuerySpecification;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.index.solr.EmbeddedSolrService;
import org.qi4j.index.solr.SolrSearch;
import org.qi4j.spi.query.EntityFinder;
import org.qi4j.spi.query.EntityFinderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrEntityQueryMixin
implements EntityFinder,
SolrSearch {
    @Service
    private EmbeddedSolrService solr;
    private Logger logger = LoggerFactory.getLogger(SolrEntityQueryMixin.class);

    public Iterable<EntityReference> findEntities(Class<?> resultType, @Optional Specification<Composite> whereClause, @Optional OrderBy[] orderBySegments, @Optional Integer firstResult, @Optional Integer maxResults, Map<String, Object> variables) throws EntityFinderException {
        try {
            QuerySpecification expr = (QuerySpecification)whereClause;
            SolrServer server = this.solr.solrServer();
            NamedList list = new NamedList();
            list.add("q", (Object)expr.query());
            list.add("rows", (Object)(maxResults != 0 ? maxResults : 10000));
            list.add("start", (Object)firstResult);
            if (orderBySegments != null && orderBySegments.length > 0) {
                for (OrderBy orderBySegment : orderBySegments) {
                    String propName = ((Member)((Object)orderBySegment.property().accessor())).getName() + "_for_sort";
                    String order = orderBySegment.order() == OrderBy.Order.ASCENDING ? "asc" : "desc";
                    list.add("sort", (Object)(propName + " " + order));
                }
            }
            SolrParams solrParams = SolrParams.toSolrParams((NamedList)list);
            this.logger.debug("Search:" + list.toString());
            QueryResponse query = server.query(solrParams);
            SolrDocumentList results = query.getResults();
            ArrayList<EntityReference> references = new ArrayList<EntityReference>(results.size());
            for (SolrDocument result : results) {
                references.add(EntityReference.parseEntityReference((String)result.getFirstValue("id").toString()));
            }
            return references;
        }
        catch (SolrServerException e) {
            throw new EntityFinderException((Throwable)e);
        }
    }

    public EntityReference findEntity(Class<?> resultType, @Optional Specification<Composite> whereClause, Map<String, Object> variables) throws EntityFinderException {
        Iterator<EntityReference> iter = this.findEntities(resultType, whereClause, null, 0, 1, variables).iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public long countEntities(Class<?> resultType, @Optional Specification<Composite> whereClause, Map<String, Object> variables) throws EntityFinderException {
        return Iterables.count(this.findEntities(resultType, whereClause, null, 0, 1, variables));
    }

    @Override
    public SolrDocumentList search(String queryString) throws SolrServerException {
        SolrServer server = this.solr.solrServer();
        NamedList list = new NamedList();
        list.add("q", (Object)queryString);
        QueryResponse query = server.query(SolrParams.toSolrParams((NamedList)list));
        return query.getResults();
    }
}

