/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.shiro.web;

import java.util.ArrayList;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.web.env.EnvironmentLoader;
import org.apache.shiro.web.env.WebEnvironment;
import org.qi4j.api.common.Optional;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.functional.Iterables;
import org.qi4j.library.shiro.Shiro;
import org.qi4j.library.shiro.ini.ShiroIniConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
public interface EnvironmentLoaderService
extends ServletContextListener,
ServiceComposite {

    public static class Mixin
    extends EnvironmentLoader
    implements ServletContextListener {
        private static final Logger LOG = LoggerFactory.getLogger((String)Shiro.LOGGER_NAME);
        @This
        private Configuration<ShiroIniConfiguration> configuration;
        @Optional
        @Service
        private Iterable<ServiceReference<Realm>> realmsRefs;

        public void contextInitialized(ServletContextEvent sce) {
            this.configuration.refresh();
            ShiroIniConfiguration config = (ShiroIniConfiguration)this.configuration.get();
            String iniResourcePath = config.iniResourcePath().get() == null ? "classpath:shiro.ini" : (String)config.iniResourcePath().get();
            sce.getServletContext().setInitParameter("shiroConfigLocations", iniResourcePath);
            WebEnvironment env = this.initEnvironment(sce.getServletContext());
            if (this.realmsRefs != null && Iterables.count(this.realmsRefs) > 0L) {
                RealmSecurityManager realmSecurityManager = (RealmSecurityManager)env.getSecurityManager();
                ArrayList<Object> iniRealms = new ArrayList<Object>(realmSecurityManager.getRealms());
                for (ServiceReference<Realm> realmRef : this.realmsRefs) {
                    iniRealms.add(realmRef.get());
                    LOG.debug("Realm Service '{}' registered!", (Object)realmRef.identity());
                }
                realmSecurityManager.setRealms(iniRealms);
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
            this.destroyEnvironment(sce.getServletContext());
        }
    }
}

