/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test;

import org.junit.After;
import org.junit.Before;
import org.qi4j.api.Qi4j;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.bootstrap.ApplicationAssembler;
import org.qi4j.bootstrap.ApplicationAssembly;
import org.qi4j.bootstrap.ApplicationAssemblyFactory;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.Energy4Java;
import org.qi4j.spi.Qi4jSPI;

public abstract class AbstractQi4jBaseTest {
    protected Qi4j api;
    protected Qi4jSPI spi;
    protected Energy4Java qi4j;
    protected ApplicationDescriptor applicationModel;
    protected Application application;

    @Before
    public void setUp() throws Exception {
        this.qi4j = new Energy4Java();
        this.applicationModel = this.newApplication();
        if (this.applicationModel == null) {
            return;
        }
        this.application = this.newApplicationInstance(this.applicationModel);
        this.initApplication(this.application);
        this.spi = this.qi4j.spi();
        this.api = this.spi;
        this.application.activate();
    }

    protected abstract void defineApplication(ApplicationAssembly var1) throws AssemblyException;

    protected Application newApplicationInstance(ApplicationDescriptor applicationModel) {
        return applicationModel.newInstance(this.qi4j.api(), new Object[0]);
    }

    protected ApplicationDescriptor newApplication() throws AssemblyException {
        ApplicationAssembler assembler = new ApplicationAssembler(){

            public ApplicationAssembly assemble(ApplicationAssemblyFactory applicationFactory) throws AssemblyException {
                ApplicationAssembly applicationAssembly = applicationFactory.newApplicationAssembly();
                applicationAssembly.setMode(Application.Mode.test);
                AbstractQi4jBaseTest.this.defineApplication(applicationAssembly);
                return applicationAssembly;
            }
        };
        try {
            return this.qi4j.newApplicationModel(assembler);
        }
        catch (AssemblyException e) {
            this.assemblyException(e);
            return null;
        }
    }

    protected void assemblyException(AssemblyException exception) throws AssemblyException {
        throw exception;
    }

    protected void initApplication(Application app) throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        if (this.application != null) {
            this.application.passivate();
        }
    }
}

