/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.cache;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.test.cache.MemoryCacheImpl;
import org.qi4j.test.cache.MemoryCachePoolService;
import org.qi4j.test.entity.AbstractEntityStoreTest;

public abstract class AbstractEntityStoreWithCacheTest
extends AbstractEntityStoreTest {
    @Optional
    @Service
    MemoryCachePoolService cachePool;

    @Override
    public void assemble(ModuleAssembly module) throws AssemblyException {
        super.assemble(module);
        this.assembleCachePool(module);
    }

    protected void assembleCachePool(ModuleAssembly module) throws AssemblyException {
        module.services(new Class[]{MemoryCachePoolService.class});
    }

    @Override
    @Test
    public void whenNewEntityThenCanFindEntityAndCorrectValues() throws Exception {
        super.whenNewEntityThenCanFindEntityAndCorrectValues();
        if (this.cachePool != null) {
            MemoryCacheImpl<?> cache = this.cachePool.singleCache();
            Assert.assertThat((Object)cache.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.gets(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.puts(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.removes(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.exists(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Override
    @Test
    public void whenRemovedEntityThenCannotFindEntity() throws Exception {
        super.whenRemovedEntityThenCannotFindEntity();
        if (this.cachePool != null) {
            MemoryCacheImpl<?> cache = this.cachePool.singleCache();
            Assert.assertThat((Object)cache.size(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.gets(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)cache.puts(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.removes(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.exists(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Override
    @Test
    public void givenEntityIsNotModifiedWhenUnitOfWorkCompletesThenDontStoreState() throws UnitOfWorkCompletionException {
        super.givenEntityIsNotModifiedWhenUnitOfWorkCompletesThenDontStoreState();
        if (this.cachePool != null) {
            MemoryCacheImpl<?> cache = this.cachePool.singleCache();
            Assert.assertThat((Object)cache.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.gets(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)cache.puts(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.removes(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.exists(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Override
    @Test
    public void givenPropertyIsModifiedWhenUnitOfWorkCompletesThenStoreState() throws UnitOfWorkCompletionException {
        super.givenPropertyIsModifiedWhenUnitOfWorkCompletesThenStoreState();
        if (this.cachePool != null) {
            MemoryCacheImpl<?> cache = this.cachePool.singleCache();
            Assert.assertThat((Object)cache.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.gets(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)cache.puts(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)cache.removes(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.exists(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Override
    @Test
    public void givenManyAssociationIsModifiedWhenUnitOfWorkCompletesThenStoreState() throws UnitOfWorkCompletionException {
        super.givenManyAssociationIsModifiedWhenUnitOfWorkCompletesThenStoreState();
        if (this.cachePool != null) {
            MemoryCacheImpl<?> cache = this.cachePool.singleCache();
            Assert.assertThat((Object)cache.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.gets(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)cache.puts(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)cache.removes(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.exists(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Override
    @Test
    public void givenConcurrentUnitOfWorksWhenUoWCompletesThenCheckConcurrentModification() throws UnitOfWorkCompletionException {
        super.givenConcurrentUnitOfWorksWhenUoWCompletesThenCheckConcurrentModification();
        if (this.cachePool != null) {
            MemoryCacheImpl<?> cache = this.cachePool.singleCache();
            Assert.assertThat((Object)cache.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.gets(), (Matcher)CoreMatchers.is((Object)4));
            Assert.assertThat((Object)cache.puts(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)cache.removes(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.exists(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Override
    @Test
    public void givenEntityStoredLoadedChangedWhenUnitOfWorkDiscardsThenDontStoreState() throws UnitOfWorkCompletionException {
        super.givenEntityStoredLoadedChangedWhenUnitOfWorkDiscardsThenDontStoreState();
        if (this.cachePool != null) {
            MemoryCacheImpl<?> cache = this.cachePool.singleCache();
            Assert.assertThat((Object)cache.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.gets(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)cache.puts(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.removes(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.exists(), (Matcher)CoreMatchers.is((Object)0));
        }
    }
}

