/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.cache;

import java.util.concurrent.ConcurrentHashMap;
import org.qi4j.spi.cache.Cache;

public class MemoryCacheImpl<T>
implements Cache<T> {
    private int refCount;
    private final ConcurrentHashMap<String, Object> backingCache;
    private final Class<T> valueType;
    private final String id;
    private int gets;
    private int removes;
    private int puts;
    private int exists;

    public MemoryCacheImpl(String cacheId, ConcurrentHashMap<String, Object> cache, Class<T> valueType) {
        this.id = cacheId;
        this.backingCache = cache;
        this.valueType = valueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String key) {
        try {
            T t = this.valueType.cast(this.backingCache.get(key));
            return t;
        }
        finally {
            ++this.gets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(String key) {
        try {
            T t = this.valueType.cast(this.backingCache.remove(key));
            return t;
        }
        finally {
            ++this.removes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, T value) {
        try {
            this.backingCache.put(key, value);
        }
        finally {
            ++this.puts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        try {
            boolean bl = this.backingCache.containsKey(key);
            return bl;
        }
        finally {
            ++this.exists;
        }
    }

    synchronized void decRefCount() {
        --this.refCount;
    }

    synchronized void incRefCount() {
        ++this.refCount;
    }

    synchronized boolean isNotUsed() {
        return this.refCount == 0;
    }

    public String cacheId() {
        return this.id;
    }

    public int size() {
        return this.backingCache.size();
    }

    public int gets() {
        return this.gets;
    }

    public int removes() {
        return this.removes;
    }

    public int puts() {
        return this.puts;
    }

    public int exists() {
        return this.exists;
    }
}

