/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.cache;

import java.util.concurrent.ConcurrentHashMap;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.functional.Iterables;
import org.qi4j.spi.cache.Cache;
import org.qi4j.test.cache.MemoryCacheImpl;
import org.qi4j.test.cache.MemoryCachePoolService;

public abstract class MemoryCachePoolMixin
implements MemoryCachePoolService {
    private final ConcurrentHashMap<String, MemoryCacheImpl<?>> caches = new ConcurrentHashMap();

    public <T> Cache<T> fetchCache(String cacheId, Class<T> valueType) {
        NullArgumentException.validateNotEmpty((String)"cacheId", (String)cacheId);
        MemoryCacheImpl<Object> cache = this.caches.get(cacheId);
        if (cache == null) {
            cache = this.createNewCache(cacheId, valueType);
            this.caches.put(cacheId, cache);
        }
        cache.incRefCount();
        return cache;
    }

    private <T> MemoryCacheImpl<T> createNewCache(String cacheId, Class<T> valueType) {
        return new MemoryCacheImpl<T>(cacheId, new ConcurrentHashMap<String, Object>(), valueType);
    }

    public void returnCache(Cache<?> cache) {
        MemoryCacheImpl memory = (MemoryCacheImpl)cache;
        memory.decRefCount();
        if (memory.isNotUsed()) {
            this.caches.remove(memory.cacheId());
        }
    }

    public void activateService() throws Exception {
        this.caches.clear();
    }

    public void passivateService() throws Exception {
        this.caches.clear();
    }

    @Override
    public MemoryCacheImpl<?> singleCache() {
        return (MemoryCacheImpl)Iterables.single(this.caches.values());
    }
}

