/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.entity;

import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.entitystore.memory.MemoryEntityStoreService;
import org.qi4j.spi.uuid.UuidIdentityGeneratorService;
import org.qi4j.test.AbstractQi4jTest;
import org.qi4j.valueserialization.orgjson.OrgJsonValueSerializationService;

public abstract class AbstractConfigurationDeserializationTest
extends AbstractQi4jTest {
    public void assemble(ModuleAssembly module) throws AssemblyException {
        ModuleAssembly storageModule = module;
        module.configurations(new Class[]{ConfigSerializationConfig.class});
        module.values(new Class[]{Host.class});
        module.services(new Class[]{MyService.class}).identifiedBy("configtest");
        storageModule.services(new Class[]{MemoryEntityStoreService.class}).visibleIn(Visibility.layer);
        storageModule.services(new Class[]{OrgJsonValueSerializationService.class}).taggedWith(new String[]{"json"});
        storageModule.services(new Class[]{UuidIdentityGeneratorService.class});
    }

    @Test
    public void givenServiceWhenInitializingExpectCorrectDeserialization() {
        ServiceReference ref = this.module.findService(MyService.class);
        Assert.assertThat((Object)ref, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)ref.isAvailable(), (Matcher)IsEqual.equalTo((Object)true));
        MyService myService = (MyService)ref.get();
        Assert.assertThat((Object)myService, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)myService.name(), (Matcher)IsEqual.equalTo((Object)"main"));
        Assert.assertThat((Object)myService.hostIp(), (Matcher)IsEqual.equalTo((Object)"12.23.34.45"));
        Assert.assertThat((Object)myService.hostPort(), (Matcher)IsEqual.equalTo((Object)1234));
    }

    public static interface Host {
        public Property<String> ip();

        public Property<Integer> port();
    }

    public static interface ConfigSerializationConfig
    extends Identity {
        public Property<String> name();

        public Property<Host> host();
    }

    public static class MyServiceMixin
    implements MyService {
        @This
        private Configuration<ConfigSerializationConfig> config;

        @Override
        public String hostIp() {
            return (String)((Host)((ConfigSerializationConfig)this.config.get()).host().get()).ip().get();
        }

        @Override
        public Integer hostPort() {
            return (Integer)((Host)((ConfigSerializationConfig)this.config.get()).host().get()).port().get();
        }

        @Override
        public String name() {
            return (String)((ConfigSerializationConfig)this.config.get()).name().get();
        }
    }

    @Mixins(value={MyServiceMixin.class})
    public static interface MyService {
        public String hostIp();

        public Integer hostPort();

        public String name();
    }
}

