/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Test;
import org.qi4j.api.property.Property;
import org.qi4j.api.query.Query;
import org.qi4j.api.query.QueryBuilder;
import org.qi4j.api.query.QueryExpressions;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.functional.Specification;
import org.qi4j.spi.query.IndexExporter;
import org.qi4j.test.indexing.AbstractAnyQueryTest;
import org.qi4j.test.indexing.NameableAssert;
import org.qi4j.test.indexing.model.Address;
import org.qi4j.test.indexing.model.Nameable;
import org.qi4j.test.indexing.model.Person;
import org.qi4j.test.indexing.model.Protocol;
import org.qi4j.test.indexing.model.QueryParam;
import org.qi4j.test.indexing.model.URL;

public abstract class AbstractComplexQueryTest
extends AbstractAnyQueryTest {
    private static final String ANN = "Ann Doe";
    private static final String JOE = "Joe Doe";
    private static final String JACK = "Jack Doe";

    @Test
    public void showNetwork() throws IOException {
        IndexExporter indexerExporter = (IndexExporter)this.module.findService(IndexExporter.class).get();
        indexerExporter.exportReadableToStream(System.out);
    }

    @Test
    public void script01() {
        ValueBuilder addressBuilder = this.module.newValueBuilder(Address.class);
        Address address = (Address)addressBuilder.prototype();
        address.line1().set((Object)"Qi Street 4j");
        address.line2().set((Object)"Off main Java Street");
        address.zipcode().set((Object)"12345");
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<Address> addressProp = ((Person)QueryExpressions.templateFor(Person.class)).address();
        qb = qb.where((Specification)QueryExpressions.eq(addressProp, (Object)addressBuilder.newInstance()));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script01: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, ANN);
    }

    @Test
    public void script02() {
        ValueBuilder addressBuilder = this.module.newValueBuilder(Address.class);
        Address address = (Address)addressBuilder.prototype();
        address.line1().set((Object)"Qi Street 4j");
        address.line2().set((Object)"Off main Java Street");
        address.zipcode().set((Object)"12345");
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<Address> addressProp = ((Person)QueryExpressions.templateFor(Person.class)).address();
        qb = qb.where((Specification)QueryExpressions.not((Specification)QueryExpressions.eq(addressProp, (Object)addressBuilder.newInstance())));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script02: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, JOE, JACK);
    }

    @Test
    public void script03() {
        ValueBuilder queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        ArrayList<Object> queryParams = new ArrayList<Object>(2);
        QueryParam param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"user");
        param.value().set((Object)"jackdoe");
        queryParams.add(queryParamBuilder.newInstance());
        queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"password");
        param.value().set((Object)"somepassword");
        queryParams.add(queryParamBuilder.newInstance());
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<Collection<QueryParam>> paramsProp = ((URL)((Person)QueryExpressions.templateFor(Person.class)).personalWebsite().get()).queryParams();
        qb = qb.where((Specification)QueryExpressions.eq(paramsProp, queryParams));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script03: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, JACK);
    }

    @Test
    public void script04() {
        ValueBuilder queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        ArrayList<Object> queryParams = new ArrayList<Object>(2);
        QueryParam param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"password");
        param.value().set((Object)"somepassword");
        queryParams.add(queryParamBuilder.newInstance());
        queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"user");
        param.value().set((Object)"jackdoe");
        queryParams.add(queryParamBuilder.newInstance());
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<Collection<QueryParam>> paramsProp = ((URL)((Person)QueryExpressions.templateFor(Person.class)).personalWebsite().get()).queryParams();
        qb = qb.where((Specification)QueryExpressions.eq(paramsProp, queryParams));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script04: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, new String[0]);
    }

    @Test
    public void script05() {
        ValueBuilder queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        ArrayList<Object> queryParams = new ArrayList<Object>(2);
        QueryParam param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"user");
        param.value().set((Object)"jackdoe");
        queryParams.add(queryParamBuilder.newInstance());
        queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"password");
        param.value().set((Object)"somepassword");
        queryParams.add(queryParamBuilder.newInstance());
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<Collection<QueryParam>> paramsProp = ((URL)((Person)QueryExpressions.templateFor(Person.class)).personalWebsite().get()).queryParams();
        qb = qb.where((Specification)QueryExpressions.not((Specification)QueryExpressions.eq(paramsProp, queryParams)));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script05: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, ANN, JOE);
    }

    @Test
    public void script06() {
        ValueBuilder urlBuilder = this.module.newValueBuilder(URL.class);
        ValueBuilder protocolBuilder = this.module.newValueBuilder(Protocol.class);
        ValueBuilder queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        Protocol protocol = (Protocol)protocolBuilder.prototype();
        protocol.value().set((Object)"http");
        ArrayList<Object> queryParams = new ArrayList<Object>(2);
        QueryParam param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"user");
        param.value().set((Object)"jackdoe");
        queryParams.add(queryParamBuilder.newInstance());
        queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"password");
        param.value().set((Object)"somepassword");
        queryParams.add(queryParamBuilder.newInstance());
        URL url = (URL)urlBuilder.prototype();
        url.protocol().set(protocolBuilder.newInstance());
        url.queryParams().set(queryParams);
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<URL> websiteProp = ((Person)QueryExpressions.templateFor(Person.class)).personalWebsite();
        qb = qb.where((Specification)QueryExpressions.eq(websiteProp, (Object)urlBuilder.newInstance()));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script06: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, JACK);
    }

    @Test
    public void script07() {
        ValueBuilder urlBuilder = this.module.newValueBuilder(URL.class);
        ValueBuilder protocolBuilder = this.module.newValueBuilder(Protocol.class);
        ValueBuilder queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        Protocol protocol = (Protocol)protocolBuilder.prototype();
        protocol.value().set((Object)"http");
        ArrayList<Object> queryParams = new ArrayList<Object>(2);
        QueryParam param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"user");
        param.value().set((Object)"jackdoe");
        queryParams.add(queryParamBuilder.newInstance());
        queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"password");
        param.value().set((Object)"somepassword");
        queryParams.add(queryParamBuilder.newInstance());
        URL url = (URL)urlBuilder.prototype();
        url.protocol().set(protocolBuilder.newInstance());
        url.queryParams().set(queryParams);
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<URL> websiteProp = ((Person)QueryExpressions.templateFor(Person.class)).personalWebsite();
        qb = qb.where((Specification)QueryExpressions.not((Specification)QueryExpressions.eq(websiteProp, (Object)urlBuilder.newInstance())));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script07: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, ANN, JOE);
    }

    @Test
    public void script08() {
        ValueBuilder queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        QueryParam param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"user");
        param.value().set((Object)"jackdoe");
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<Collection<QueryParam>> paramsProp = ((URL)((Person)QueryExpressions.templateFor(Person.class)).personalWebsite().get()).queryParams();
        qb = qb.where((Specification)QueryExpressions.contains(paramsProp, (Object)queryParamBuilder.newInstance()));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script08: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, JACK);
    }

    @Test
    public void script09() {
        ValueBuilder queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        QueryParam param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"user");
        param.value().set((Object)"jackdoe");
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<Collection<QueryParam>> paramsProp = ((URL)((Person)QueryExpressions.templateFor(Person.class)).personalWebsite().get()).queryParams();
        qb = qb.where((Specification)QueryExpressions.not((Specification)QueryExpressions.contains(paramsProp, (Object)queryParamBuilder.newInstance())));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script09: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, ANN, JOE);
    }

    @Test
    public void script10() {
        ValueBuilder queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        ArrayList<Object> queryParams = new ArrayList<Object>(2);
        QueryParam param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"user");
        param.value().set((Object)"jackdoe");
        queryParams.add(queryParamBuilder.newInstance());
        queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"password");
        param.value().set((Object)"somepassword");
        queryParams.add(queryParamBuilder.newInstance());
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<Collection<QueryParam>> paramsProp = ((URL)((Person)QueryExpressions.templateFor(Person.class)).personalWebsite().get()).queryParams();
        qb = qb.where((Specification)QueryExpressions.containsAll(paramsProp, queryParams));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script10: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, JACK);
    }

    @Test
    public void script11() {
        ValueBuilder queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        ArrayList<Object> queryParams = new ArrayList<Object>(2);
        QueryParam param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"user");
        param.value().set((Object)"jackdoe");
        queryParams.add(queryParamBuilder.newInstance());
        queryParamBuilder = this.module.newValueBuilder(QueryParam.class);
        param = (QueryParam)queryParamBuilder.prototype();
        param.name().set((Object)"password");
        param.value().set((Object)"somepassword");
        queryParams.add(queryParamBuilder.newInstance());
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Property<Collection<QueryParam>> paramsProp = ((URL)((Person)QueryExpressions.templateFor(Person.class)).personalWebsite().get()).queryParams();
        qb = qb.where((Specification)QueryExpressions.not((Specification)QueryExpressions.containsAll(paramsProp, queryParams)));
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script11: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, ANN, JOE);
    }
}

