/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.query.QueryExpressions;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.api.query.grammar.Variable;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.spi.query.EntityFinder;
import org.qi4j.spi.query.EntityFinderException;
import org.qi4j.spi.query.IndexExporter;
import org.qi4j.test.indexing.AbstractAnyQueryTest;
import org.qi4j.test.indexing.NameableAssert;
import org.qi4j.test.indexing.model.City;
import org.qi4j.test.indexing.model.Domain;
import org.qi4j.test.indexing.model.Female;
import org.qi4j.test.indexing.model.Male;
import org.qi4j.test.indexing.model.Nameable;
import org.qi4j.test.indexing.model.Person;

public abstract class AbstractEntityFinderTest
extends AbstractAnyQueryTest {
    private static final Specification<Composite> ALL = null;
    private static final OrderBy[] NO_SORTING = null;
    private static final Integer NO_FIRST_RESULT = null;
    private static final Integer NO_MAX_RESULTS = null;
    private static final Map<String, Object> NO_VARIABLES = Collections.emptyMap();
    private static final String JACK = "Jack Doe";
    private static final String JOE = "Joe Doe";
    private static final String ANN = "Ann Doe";
    private EntityFinder entityFinder;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.entityFinder = (EntityFinder)this.module.findService(EntityFinder.class).get();
    }

    @Test
    public void showNetwork() throws IOException {
        ServiceReference indexerService = this.module.findService(IndexExporter.class);
        IndexExporter exporter = (IndexExporter)indexerService.get();
        exporter.exportReadableToStream(System.out);
    }

    @Test
    public void script01() throws EntityFinderException {
        Iterable entities = this.entityFinder.findEntities(Person.class, ALL, NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JOE, JACK, ANN);
    }

    @Test
    public void script02() throws EntityFinderException {
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Iterable entities = this.entityFinder.findEntities(Domain.class, (Specification)QueryExpressions.eq(nameable.name(), (Object)"Gaming"), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, "Gaming");
    }

    @Test
    public void script03() throws EntityFinderException {
        Iterable entities = this.entityFinder.findEntities(Nameable.class, ALL, NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, NameableAssert.allNames());
    }

    @Test
    public void script04() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, (Specification)QueryExpressions.eq(((City)person.placeOfBirth().get()).name(), (Object)"Kuala Lumpur"), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JOE, ANN);
    }

    @Test
    public void script05() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, (Specification)QueryExpressions.eq(((City)((Female)person.mother().get()).placeOfBirth().get()).name(), (Object)"Kuala Lumpur"), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JOE);
    }

    @Test
    public void script06() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, (Specification)QueryExpressions.ge(person.yearOfBirth(), (Object)1973), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JOE, ANN);
    }

    @Test
    public void script07() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Nameable.class, (Specification)QueryExpressions.and((Specification)QueryExpressions.ge(person.yearOfBirth(), (Object)1900), (Specification)QueryExpressions.eq(((City)person.placeOfBirth().get()).name(), (Object)"Penang"), (Specification[])new Specification[0]), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JACK);
    }

    @Test
    public void script08() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, (Specification)QueryExpressions.or((Specification[])new Specification[]{QueryExpressions.eq(person.yearOfBirth(), (Object)1970), QueryExpressions.eq(person.yearOfBirth(), (Object)1975)}), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JACK, ANN);
    }

    @Test
    public void script09() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Female.class, (Specification)QueryExpressions.or((Specification[])new Specification[]{QueryExpressions.eq(person.yearOfBirth(), (Object)1970), QueryExpressions.eq(person.yearOfBirth(), (Object)1975)}), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, ANN);
    }

    @Test
    public void script10() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, (Specification)QueryExpressions.not((Specification)QueryExpressions.eq(person.yearOfBirth(), (Object)1975)), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JOE, JACK);
    }

    @Test
    public void script11() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, (Specification)QueryExpressions.isNotNull(person.email()), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JOE);
    }

    @Test
    public void script12() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, (Specification)QueryExpressions.isNull(person.email()), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, ANN, JACK);
    }

    @Test
    public void script13() throws EntityFinderException {
        Male person = (Male)QueryExpressions.templateFor(Male.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, (Specification)QueryExpressions.isNotNull(person.wife()), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JACK);
    }

    @Test
    public void script14() throws EntityFinderException {
        Male person = (Male)QueryExpressions.templateFor(Male.class);
        Iterable entities = this.entityFinder.findEntities(Male.class, (Specification)QueryExpressions.isNull(person.wife()), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JOE);
    }

    @Test
    public void script15() throws EntityFinderException {
        Male person = (Male)QueryExpressions.templateFor(Male.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, (Specification)QueryExpressions.isNull(person.wife()), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, ANN, JOE);
    }

    @Test
    public void script16() throws EntityFinderException {
        List references = Iterables.toList((Iterable)this.entityFinder.findEntities(Nameable.class, ALL, NO_SORTING, NO_FIRST_RESULT, Integer.valueOf(2), NO_VARIABLES));
        Assert.assertEquals((String)"2 identitities", (long)2L, (long)references.size());
    }

    @Test
    public void script17() throws EntityFinderException {
        List references = Iterables.toList((Iterable)this.entityFinder.findEntities(Nameable.class, ALL, NO_SORTING, Integer.valueOf(3), Integer.valueOf(2), NO_VARIABLES));
        Assert.assertEquals((String)"2 identitities", (long)2L, (long)references.size());
    }

    @Test
    public void script18() throws EntityFinderException {
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Object[] allNames = NameableAssert.allNames();
        Arrays.sort(allNames);
        Iterable entities = this.entityFinder.findEntities(Nameable.class, ALL, new OrderBy[]{QueryExpressions.orderBy(nameable.name())}, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(false, entities, (String[])allNames);
    }

    @Test
    public void script19() throws EntityFinderException {
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        ArrayList<String> largerThanB = new ArrayList<String>();
        for (String name : NameableAssert.allNames()) {
            if (name.compareTo("B") <= 0) continue;
            largerThanB.add(name);
        }
        Collections.sort(largerThanB);
        Iterable entities = this.entityFinder.findEntities(Nameable.class, (Specification)QueryExpressions.gt(nameable.name(), (Object)"B"), new OrderBy[]{QueryExpressions.orderBy(nameable.name())}, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(false, entities, largerThanB.toArray(new String[largerThanB.size()]));
    }

    @Test
    public void script20() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, (Specification)QueryExpressions.gt(person.yearOfBirth(), (Object)1973), new OrderBy[]{QueryExpressions.orderBy(person.name(), (OrderBy.Order)OrderBy.Order.DESCENDING)}, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(false, entities, JOE, ANN);
    }

    @Test
    public void script21() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Iterable entities = this.entityFinder.findEntities(Person.class, ALL, new OrderBy[]{QueryExpressions.orderBy(((City)person.placeOfBirth().get()).name()), QueryExpressions.orderBy(person.name())}, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(false, entities, ANN, JOE, JACK);
    }

    @Test
    public void script22() throws EntityFinderException {
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Iterable entities = this.entityFinder.findEntities(Nameable.class, (Specification)QueryExpressions.matches(nameable.name(), (String)"J.*Doe"), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, NO_VARIABLES);
        NameableAssert.assertNames(entities, JACK, JOE);
    }

    @Test
    public void script23() throws EntityFinderException {
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        HashMap<String, String> variables = new HashMap<String, String>(1);
        variables.put("domain", "Gaming");
        Iterable entities = this.entityFinder.findEntities(Domain.class, (Specification)QueryExpressions.eq(nameable.name(), (Variable)QueryExpressions.variable((String)"domain")), NO_SORTING, NO_FIRST_RESULT, NO_MAX_RESULTS, variables);
        NameableAssert.assertNames(entities, "Gaming");
    }
}

