/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.indexing;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.qi4j.api.query.NotQueryableException;
import org.qi4j.api.query.Query;
import org.qi4j.api.query.QueryBuilder;
import org.qi4j.api.query.QueryExpressions;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.functional.Specification;
import org.qi4j.spi.query.EntityFinderException;
import org.qi4j.spi.query.IndexExporter;
import org.qi4j.test.indexing.AbstractAnyQueryTest;
import org.qi4j.test.indexing.NameableAssert;
import org.qi4j.test.indexing.model.Account;
import org.qi4j.test.indexing.model.Address;
import org.qi4j.test.indexing.model.City;
import org.qi4j.test.indexing.model.Domain;
import org.qi4j.test.indexing.model.Female;
import org.qi4j.test.indexing.model.File;
import org.qi4j.test.indexing.model.Host;
import org.qi4j.test.indexing.model.Male;
import org.qi4j.test.indexing.model.Nameable;
import org.qi4j.test.indexing.model.Person;
import org.qi4j.test.indexing.model.Port;
import org.qi4j.test.indexing.model.Protocol;
import org.qi4j.test.indexing.model.QueryParam;
import org.qi4j.test.indexing.model.URL;

public abstract class AbstractQueryTest
extends AbstractAnyQueryTest {
    @Test
    public void showNetwork() throws IOException {
        IndexExporter indexerExporter = (IndexExporter)this.module.findService(IndexExporter.class).get();
        indexerExporter.exportReadableToStream(System.out);
    }

    @Test
    public void script01() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script01: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe", "Jack Doe");
    }

    @Test
    public void script02() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Domain.class);
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(nameable.name(), (Object)"Gaming")));
        System.out.println("*** script02: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Gaming");
    }

    @Test
    public void script03() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Nameable.class);
        Query query = this.unitOfWork.newQuery(qb);
        System.out.println("*** script03: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe", "Jack Doe", "Penang", "Kuala Lumpur", "Cooking", "Gaming", "Programming", "Cars");
    }

    @Test
    public void script04() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person personTemplate = (Person)QueryExpressions.templateFor(Person.class);
        City placeOfBirth = (City)personTemplate.placeOfBirth().get();
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(placeOfBirth.name(), (Object)"Kuala Lumpur")));
        System.out.println("*** script04: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe");
    }

    @Test
    public void script04_ne() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person personTemplate = (Person)QueryExpressions.templateFor(Person.class);
        City placeOfBirth = (City)personTemplate.placeOfBirth().get();
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(placeOfBirth.name(), (Object)"Kuala Lumpur")));
        System.out.println("*** script04_ne: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script05() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(((City)((Female)person.mother().get()).placeOfBirth().get()).name(), (Object)"Kuala Lumpur")));
        System.out.println("*** script05: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script06() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ge(person.yearOfBirth(), (Object)1973)));
        System.out.println("*** script06: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe");
    }

    @Test
    public void script07() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Nameable.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.and((Specification)QueryExpressions.ge(person.yearOfBirth(), (Object)1900), (Specification)QueryExpressions.eq(((City)person.placeOfBirth().get()).name(), (Object)"Penang"), (Specification[])new Specification[0])));
        System.out.println("*** script07: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script08() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.or((Specification[])new Specification[]{QueryExpressions.eq(person.yearOfBirth(), (Object)1970), QueryExpressions.eq(person.yearOfBirth(), (Object)1975)})));
        System.out.println("*** script08: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Ann Doe");
    }

    @Test
    public void script09() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Female.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.or((Specification[])new Specification[]{QueryExpressions.eq(person.yearOfBirth(), (Object)1970), QueryExpressions.eq(person.yearOfBirth(), (Object)1975)})));
        System.out.println("*** script09: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Ann Doe");
    }

    @Test
    public void script10() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.not((Specification)QueryExpressions.eq(person.yearOfBirth(), (Object)1975))));
        System.out.println("*** script10: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Joe Doe");
    }

    @Test
    public void script11() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.isNotNull(person.email())));
        System.out.println("*** script11: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script12() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.isNull(person.email())));
        System.out.println("*** script12: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Ann Doe", "Jack Doe");
    }

    @Test
    public void script12_ne() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.email(), (Object)"joe@thedoes.net")));
        System.out.println("*** script12_ne: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, new String[0]);
    }

    @Test
    public void script13() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Male person = (Male)QueryExpressions.templateFor(Male.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.isNotNull(person.wife())));
        System.out.println("*** script13: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script14() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Male.class);
        Male person = (Male)QueryExpressions.templateFor(Male.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.isNull(person.wife())));
        System.out.println("*** script14: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script15() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Male person = (Male)QueryExpressions.templateFor(Male.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.isNull(person.wife())));
        System.out.println("*** script15: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe");
    }

    @Test
    public void script16() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Nameable.class);
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(qb);
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(nameable.name())});
        query.maxResults(2);
        System.out.println("*** script16: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Ann Doe", "Cars");
    }

    @Test
    public void script17() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Nameable.class);
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(qb);
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(nameable.name())});
        query.firstResult(3);
        query.maxResults(2);
        System.out.println("*** script17: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Gaming", "Jack Doe");
    }

    @Test
    public void script18() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Nameable.class);
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(qb);
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(nameable.name())});
        System.out.println("*** script18: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Ann Doe", "Cars", "Cooking", "Gaming", "Jack Doe", "Joe Doe", "Kuala Lumpur", "Penang", "Programming");
    }

    @Test
    public void script19() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Nameable.class);
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.gt(nameable.name(), (Object)"D")));
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(nameable.name())});
        System.out.println("*** script19: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Gaming", "Jack Doe", "Joe Doe", "Kuala Lumpur", "Penang", "Programming");
    }

    @Test
    public void script20() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.gt(person.yearOfBirth(), (Object)1973)));
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(person.name(), (OrderBy.Order)OrderBy.Order.DESCENDING)});
        System.out.println("*** script20: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe");
    }

    @Test
    public void script21() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb);
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(((City)person.placeOfBirth().get()).name()), QueryExpressions.orderBy(person.yearOfBirth())});
        System.out.println("*** script21: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Ann Doe", "Joe Doe", "Jack Doe");
    }

    @Test
    public void script22() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Nameable.class);
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.matches(nameable.name(), (String)"J.*Doe")));
        System.out.println("*** script22: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Joe Doe");
    }

    @Test
    public void script23() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Domain interests = (Domain)QueryExpressions.oneOf(person.interests());
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(interests.name(), (Object)"Cars")));
        System.out.println("*** script23: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script24() throws EntityFinderException {
        QueryBuilder qb = this.module.newQueryBuilder(Domain.class);
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(nameable.name(), (Object)"Gaming")));
        System.out.println("*** script24: " + query);
        Assert.assertThat((Object)((Domain)query.find()).name().get(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"Gaming")));
    }

    @Test(expected=NotQueryableException.class)
    public void script25() {
        this.module.newQueryBuilder(File.class);
    }

    @Test(expected=NotQueryableException.class)
    public void script26() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        qb.where((Specification)QueryExpressions.eq(((File)((URL)person.personalWebsite().get()).file().get()).value(), (Object)"some/path"));
    }

    @Test(expected=NotQueryableException.class)
    public void script27() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        qb.where((Specification)QueryExpressions.eq(((Host)((URL)person.personalWebsite().get()).host().get()).value(), (Object)"www.qi4j.org"));
    }

    @Test(expected=NotQueryableException.class)
    public void script28() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        qb.where((Specification)QueryExpressions.eq(((Port)((URL)person.personalWebsite().get()).port().get()).value(), (Object)8080));
    }

    @Test
    public void script29() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(((Protocol)((URL)person.personalWebsite().get()).protocol().get()).value(), (Object)"http")));
        System.out.println("*** script29: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    @Ignore(value="Wait till 1.1?")
    public void script30() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        QueryParam queryParam = null;
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.and((Specification)QueryExpressions.eq(queryParam.name(), (Object)"foo"), (Specification)QueryExpressions.eq(queryParam.value(), (Object)"bar"), (Specification[])new Specification[0])));
        System.out.println("*** script30: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    @Ignore(value="Equality on Property<Map<?,?>> not implemented")
    public void script31() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        HashMap info = new HashMap(0);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(person.additionalInfo(), info)));
        System.out.println("*** script31: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script32() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(((Address)person.address().get()).line1(), (Object)"Qi Alley 4j")));
        System.out.println("*** script32: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script33() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Domain gaming = (Domain)this.unitOfWork.get(Domain.class, "Gaming");
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.contains(person.interests(), (Object)gaming)));
        System.out.println("*** script33: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script34() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Female annDoe = (Female)this.unitOfWork.get(Female.class, "anndoe");
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(person.mother(), (Object)annDoe)));
        System.out.println("*** script34: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script35() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.containsName(person.accounts(), (String)"anns")));
        System.out.println("*** script35: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Ann Doe");
    }

    @Test
    public void script36() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Account anns = (Account)this.unitOfWork.get(Account.class, "accountOfAnnDoe");
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.contains(person.accounts(), (Object)anns)));
        System.out.println("*** script36: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Ann Doe");
    }

    @Test
    @Ignore(value="Traversing of NamedAssociations is not implemented")
    public void script37() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(((Account)person.accounts().get("anns")).number(), (Object)"accountOfAnnDoe")));
        System.out.println("*** script37: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Ann Doe");
    }

    @Test
    public void script38() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(person.title(), (Object)((Object)Person.Title.DR))));
        System.out.println("*** script38: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script39() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.title(), (Object)((Object)Person.Title.DR))));
        System.out.println("*** script39: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Ann Doe", "Joe Doe");
    }

    @Test
    public void script40_Date() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(person.dateValue(), (Object)new DateTime((Object)"2010-03-04T13:24:35", DateTimeZone.UTC).toDate())));
        System.out.println("*** script40_Date: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script41_Date() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.dateValue(), (Object)new DateTime((Object)"2010-03-04T13:24:35", DateTimeZone.UTC).toDate())));
        System.out.println("*** script41_Date: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script42_Date() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.dateValue(), (Object)new DateTime((Object)"2010-03-04T14:24:35", DateTimeZone.forID((String)"CET")).toDate())));
        System.out.println("*** script42_Date: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script43_Date() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.and((Specification)QueryExpressions.gt(person.dateValue(), (Object)new DateTime((Object)"2005-03-04T13:24:35", DateTimeZone.UTC).toDate()), (Specification)QueryExpressions.lt(person.dateValue(), (Object)new DateTime((Object)"2015-03-04T13:24:35", DateTimeZone.UTC).toDate()), (Specification[])new Specification[0])));
        System.out.println("*** script43_Date: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script40_DateTime() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(person.dateTimeValue(), (Object)new DateTime((Object)"2010-03-04T13:24:35", DateTimeZone.UTC))));
        System.out.println("*** script40_DateTime: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script41_DateTime() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.dateTimeValue(), (Object)new DateTime((Object)"2010-03-04T13:24:35", DateTimeZone.UTC))));
        System.out.println("*** script41_DateTime: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script42_DateTime() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.dateTimeValue(), (Object)new DateTime((Object)"2010-03-04T14:24:35", DateTimeZone.forID((String)"CET")))));
        System.out.println("*** script42_DateTime: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Joe Doe");
    }

    @Test
    public void script43_DateTime() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.and((Specification)QueryExpressions.gt(person.dateTimeValue(), (Object)new DateTime((Object)"2005-03-04T13:24:35", DateTimeZone.UTC)), (Specification)QueryExpressions.lt(person.dateTimeValue(), (Object)new DateTime((Object)"2015-03-04T13:24:35", DateTimeZone.UTC)), (Specification[])new Specification[0])));
        System.out.println("*** script43_DateTime: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script40_LocalDateTime() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(person.localDateTimeValue(), (Object)new LocalDateTime((Object)"2010-03-04T13:23:00", DateTimeZone.UTC))));
        System.out.println("*** script40_LocalDateTime: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script41_LocalDateTime() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.localDateTimeValue(), (Object)new LocalDateTime((Object)"2010-03-04T13:23:00", DateTimeZone.UTC))));
        System.out.println("*** script41_LocalDateTime: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script42_LocalDateTime() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.localDateTimeValue(), (Object)new LocalDateTime((Object)"2010-03-04T13:23:00", DateTimeZone.forID((String)"CET")))));
        System.out.println("*** script42_LocalDateTime: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script43_LocalDateTime() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.and((Specification)QueryExpressions.gt(person.localDateTimeValue(), (Object)new LocalDateTime((Object)"2005-03-04T13:24:35", DateTimeZone.UTC)), (Specification)QueryExpressions.lt(person.localDateTimeValue(), (Object)new LocalDateTime((Object)"2015-03-04T13:24:35", DateTimeZone.UTC)), (Specification[])new Specification[0])));
        System.out.println("*** script43_LocalDateTime: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script40_LocalDate() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(person.localDateValue(), (Object)new LocalDate((Object)"2010-03-04", DateTimeZone.UTC))));
        System.out.println("*** script40_LocalDate: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script41_LocalDate() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.localDateValue(), (Object)new LocalDate((Object)"2010-03-04", DateTimeZone.UTC))));
        System.out.println("*** script41_LocalDate: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script42_LocalDate() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.localDateValue(), (Object)new LocalDate((Object)"2010-03-04", DateTimeZone.forID((String)"CET")))));
        System.out.println("*** script42_LocalDate: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script43_LocalDate() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.and((Specification)QueryExpressions.gt(person.localDateValue(), (Object)new LocalDate((Object)"2005-03-04", DateTimeZone.UTC)), (Specification)QueryExpressions.lt(person.localDateValue(), (Object)new LocalDate((Object)"2015-03-04", DateTimeZone.UTC)), (Specification[])new Specification[0])));
        System.out.println("*** script43_LocalDate: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script50_BigInteger() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(person.bigInteger(), (Object)new BigInteger("23232323232323232323232323"))));
        System.out.println("*** script50_BigInteger: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script51_BigInteger() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.bigInteger(), (Object)new BigInteger("23232323232323232323232323"))));
        System.out.println("*** script51_BigInteger: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script52_BigInteger() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ge(person.bigInteger(), (Object)new BigInteger("23232323232323232323232323"))));
        System.out.println("*** script52_BigInteger: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Joe Doe");
    }

    @Test
    public void script50_BigDecimal() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.eq(person.bigDecimal(), (Object)new BigDecimal("2342.76931348623157e+307"))));
        System.out.println("*** script50_BigDecimal: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script51_BigDecimal() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ne(person.bigDecimal(), (Object)new BigDecimal("2342.76931348623157e+307"))));
        System.out.println("*** script51_BigDecimal: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script52_BigDecimal() {
        QueryBuilder qb = this.module.newQueryBuilder(Person.class);
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(qb.where((Specification)QueryExpressions.ge(person.bigDecimal(), (Object)new BigDecimal("2342.76931348623157e+307"))));
        System.out.println("*** script52_BigDecimal: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Joe Doe");
    }
}

