/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.util;

import java.io.File;
import java.io.IOException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DelTreeAfter
implements TestRule {
    private final boolean createDirsBefore;
    private final File[] directories;

    public DelTreeAfter(File ... directories) {
        this(false, directories);
    }

    public DelTreeAfter(boolean createDirsBefore, File[] directories) {
        this.createDirsBefore = createDirsBefore;
        this.directories = directories;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                if (DelTreeAfter.this.createDirsBefore) {
                    for (File dir : DelTreeAfter.this.directories) {
                        if (dir.mkdirs()) continue;
                        throw new IOException("Unable to create directory: " + dir);
                    }
                }
                try {
                    base.evaluate();
                }
                finally {
                    if (DelTreeAfter.this.directories != null) {
                        for (File dir : DelTreeAfter.this.directories) {
                            if (!dir.exists()) continue;
                            DelTreeAfter.delTree(dir);
                        }
                    }
                }
            }
        };
    }

    private static void delTree(File dir) {
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                DelTreeAfter.delTree(file);
            }
            dir.delete();
        } else {
            dir.delete();
        }
    }
}

