/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.property.Property;
import org.qi4j.api.type.CollectionType;
import org.qi4j.api.type.MapType;
import org.qi4j.api.type.ValueCompositeType;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.io.Inputs;
import org.qi4j.io.Output;
import org.qi4j.io.Outputs;
import org.qi4j.io.Transforms;
import org.qi4j.test.AbstractQi4jTest;

public class AbstractCollectionSerializationTest
extends AbstractQi4jTest {
    @Service
    protected ValueSerialization valueSerialization;

    public void assemble(ModuleAssembly module) throws AssemblyException {
        module.values(new Class[]{SomeValue.class});
    }

    @Before
    public void before() {
        this.module.injectTo((Object)this, new Object[0]);
    }

    @Test
    public void testIOString() throws Exception {
        StringBuilder sb = new StringBuilder();
        Inputs.iterable(this.byteCollection()).transferTo(Transforms.map((Function)this.valueSerialization.serialize(), (Output)Outputs.text((StringBuilder)sb)));
        String output = sb.toString();
        ArrayList list = new ArrayList();
        Inputs.text((String)output).transferTo(Transforms.map((Function)this.valueSerialization.deserialize(Byte.class), (Output)Outputs.collection(list)));
        Assert.assertEquals(this.byteCollection(), list);
    }

    @Test
    public void givenPrimitiveArrayWithIntsWhenSerializingAndDeserializingExpectEquals() throws Exception {
        int[] primitiveArray = new int[]{23, 42, -23, -42};
        String output = this.valueSerialization.serialize((Object)primitiveArray);
        int[] deserialized = (int[])this.valueSerialization.deserialize(int[].class, output);
        Assert.assertArrayEquals((int[])primitiveArray, (int[])deserialized);
    }

    @Test
    public void givenArrayWithByteAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        Object[] array = new Byte[]{(byte)9, null, (byte)-12, (byte)-12, (byte)127, (byte)-128, (byte)73};
        String output = this.valueSerialization.serialize((Object)array);
        Object[] deserialized = (Byte[])this.valueSerialization.deserialize(Byte[].class, output);
        Assert.assertArrayEquals((Object[])array, (Object[])deserialized);
    }

    @Test
    public void givenIterableTypeWithByteAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize((Object)Iterables.iterable((Object[])this.byteCollection().toArray()));
        CollectionType collectionType = new CollectionType(List.class, new ValueType(Byte.class));
        List list = (List)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.byteCollection(), (Object)list);
    }

    @Test
    public void givenCollectionTypeWithByteAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.byteCollection());
        CollectionType collectionType = new CollectionType(Set.class, new ValueType(Byte.class));
        Set list = (Set)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(new LinkedHashSet<Byte>(this.byteCollection()), (Object)list);
    }

    @Test
    public void givenCollectionTypeWithCharacterAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.characterCollection());
        CollectionType collectionType = new CollectionType(List.class, new ValueType(Character.class));
        List list = (List)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.characterCollection(), (Object)list);
    }

    @Test
    public void givenCollectionTypeWithShortAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.shortCollection());
        CollectionType collectionType = new CollectionType(List.class, new ValueType(Short.class));
        List list = (List)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.shortCollection(), (Object)list);
    }

    @Test
    public void givenCollectionTypeWithIntegerAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.integerCollection());
        CollectionType collectionType = new CollectionType(List.class, new ValueType(Integer.class));
        List list = (List)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.integerCollection(), (Object)list);
    }

    @Test
    public void givenCollectionTypeWithLongAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.longCollection());
        CollectionType collectionType = new CollectionType(List.class, new ValueType(Long.class));
        List list = (List)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.longCollection(), (Object)list);
    }

    @Test
    public void givenCollectionTypeWithFloatAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.floatCollection());
        CollectionType collectionType = new CollectionType(List.class, new ValueType(Float.class));
        List list = (List)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.floatCollection(), (Object)list);
    }

    @Test
    public void givenCollectionTypeWithDoubleAndNullElementWhenSerializingExpectCorrectJsonOutput() throws Exception {
        String output = this.valueSerialization.serialize(this.doubleCollection());
        CollectionType collectionType = new CollectionType(List.class, new ValueType(Double.class));
        List list = (List)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.doubleCollection(), (Object)list);
    }

    @Test
    public void givenCollectionTypeWithBigIntegerAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.bigIntegerCollection());
        CollectionType collectionType = new CollectionType(List.class, new ValueType(BigInteger.class));
        List list = (List)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.bigIntegerCollection(), (Object)list);
    }

    @Test
    public void givenCollectionTypeWithBigDecimalAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.bigDecimalCollection());
        CollectionType collectionType = new CollectionType(Collection.class, new ValueType(BigDecimal.class));
        Collection collection = (Collection)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.bigDecimalCollection(), (Object)collection);
    }

    @Test
    public void givenMapOfStringByteAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.stringByteMap());
        MapType mapType = new MapType(Map.class, new ValueType(String.class), new ValueType(Byte.class));
        Map value = (Map)this.valueSerialization.deserialize((ValueType)mapType, output);
        Assert.assertEquals(this.stringByteMap(), (Object)value);
    }

    @Test
    public void givenMapOfStringListStringAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.stringMultiMap());
        CollectionType collectionType = new CollectionType(List.class, new ValueType(String.class));
        MapType mapType = new MapType(Map.class, new ValueType(String.class), (ValueType)collectionType);
        Map value = (Map)this.valueSerialization.deserialize((ValueType)mapType, output);
        Assert.assertEquals(this.stringMultiMap(), (Object)value);
    }

    @Test
    public void givenListOfMapStringStringAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.stringListOfMaps());
        ValueType stringType = new ValueType(String.class);
        CollectionType collectionType = new CollectionType(List.class, (ValueType)new MapType(Map.class, stringType, stringType));
        List value = (List)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.stringListOfMaps(), (Object)value);
    }

    @Test
    public void givenListOfValueCompositesAndNullElementWhenSerializingAndDeserializingExpectEquals() throws Exception {
        String output = this.valueSerialization.serialize(this.valueCompositesList());
        ValueCompositeType valueType = this.module.valueDescriptor(SomeValue.class.getName()).valueType();
        CollectionType collectionType = new CollectionType(List.class, (ValueType)valueType);
        List value = (List)this.valueSerialization.deserialize((ValueType)collectionType, output);
        Assert.assertEquals(this.valueCompositesList(), (Object)value);
    }

    private ArrayList<Byte> byteCollection() {
        ArrayList<Byte> value = new ArrayList<Byte>();
        value.add((byte)9);
        value.add(null);
        value.add((byte)-12);
        value.add((byte)-12);
        value.add((byte)127);
        value.add((byte)-128);
        value.add((byte)73);
        return value;
    }

    private List<Character> characterCollection() {
        ArrayList<Character> value = new ArrayList<Character>();
        value.add(Character.valueOf('Q'));
        value.add(Character.valueOf('i'));
        value.add(null);
        value.add(Character.valueOf('4'));
        value.add(Character.valueOf('j'));
        return value;
    }

    private Collection<Short> shortCollection() {
        ArrayList<Short> value = new ArrayList<Short>();
        value.add((short)Short.MIN_VALUE);
        value.add((short)Short.MAX_VALUE);
        value.add((short)-82);
        value.add(null);
        return value;
    }

    private Collection<Integer> integerCollection() {
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(Integer.MAX_VALUE);
        value.add(-283);
        value.add(null);
        value.add(Integer.MIN_VALUE);
        value.add(238);
        return value;
    }

    private Collection<Long> longCollection() {
        ArrayList<Long> value = new ArrayList<Long>();
        value.add(98239723L);
        value.add(-1298233L);
        value.add(-1L);
        value.add(0L);
        value.add(null);
        value.add(1L);
        value.add(Long.MAX_VALUE);
        value.add(Long.MIN_VALUE);
        return value;
    }

    private Collection<Float> floatCollection() {
        ArrayList<Float> value = new ArrayList<Float>();
        value.add(Float.valueOf(-1.0f));
        value.add(Float.valueOf(1.0f));
        value.add(Float.valueOf(1.0f));
        value.add(Float.valueOf(0.0f));
        value.add(Float.valueOf(Float.MAX_VALUE));
        value.add(Float.valueOf(Float.MIN_VALUE));
        value.add(null);
        value.add(Float.valueOf(0.123456f));
        value.add(Float.valueOf(-0.232321f));
        return value;
    }

    private Collection<Double> doubleCollection() {
        ArrayList<Double> value = new ArrayList<Double>();
        value.add(-1.0);
        value.add(1.0);
        value.add(0.0);
        value.add((Double)Double.MAX_VALUE);
        value.add(null);
        value.add((Double)Double.MIN_VALUE);
        value.add(0.123456);
        value.add(-0.232321);
        return value;
    }

    private Collection<BigInteger> bigIntegerCollection() {
        ArrayList<BigInteger> value = new ArrayList<BigInteger>();
        value.add(new BigInteger("-1"));
        value.add(BigInteger.ZERO);
        value.add(BigInteger.ONE);
        value.add(null);
        value.add(BigInteger.TEN);
        value.add(new BigInteger("-1827368263823729372397239829332"));
        value.add(new BigInteger("2398723982982379827373972398723"));
        return value;
    }

    private Collection<BigDecimal> bigDecimalCollection() {
        ArrayList<BigDecimal> value = new ArrayList<BigDecimal>();
        value.add(new BigDecimal("1.2"));
        value.add(new BigDecimal("3.4"));
        value.add(null);
        value.add(new BigDecimal("5.6"));
        return value;
    }

    private Map<String, Byte> stringByteMap() {
        LinkedHashMap<String, Byte> value = new LinkedHashMap<String, Byte>();
        value.put("a", (byte)9);
        value.put("b", null);
        value.put("c", (byte)-12);
        return value;
    }

    private Map<String, List<String>> stringMultiMap() {
        LinkedHashMap<String, List<String>> value = new LinkedHashMap<String, List<String>>();
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        list.add(null);
        list.add("cathedral");
        list.add("bazar");
        value.put("alpha", list);
        value.put("beta", null);
        value.put("gamma", Collections.emptyList());
        return value;
    }

    private List<Map<String, String>> stringListOfMaps() {
        ArrayList<Map<String, String>> value = new ArrayList<Map<String, String>>();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("foo", "bar");
        map.put("cathedral", "bazar");
        map.put("yield", null);
        map.put("42", "23");
        value.add(map);
        value.add(null);
        value.add(Collections.emptyMap());
        return value;
    }

    private List<SomeValue> valueCompositesList() {
        ArrayList<SomeValue> list = new ArrayList<SomeValue>();
        list.add(this.newSomeValue("", "bazar"));
        list.add(null);
        list.add(this.newSomeValue("bar", null));
        return list;
    }

    private SomeValue newSomeValue(String foo, String cathedral) {
        ValueBuilder builder = this.module.newValueBuilder(SomeValue.class);
        SomeValue value = (SomeValue)builder.prototype();
        value.foo().set((Object)foo);
        if (cathedral != null) {
            value.cathedral().set((Object)cathedral);
        }
        return (SomeValue)builder.newInstance();
    }

    public static interface SomeValue {
        public Property<String> foo();

        @Optional
        public Property<String> cathedral();
    }
}

