/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.test.AbstractQi4jTest;

public abstract class AbstractPlainValueSerializationTest
extends AbstractQi4jTest {
    @Service
    protected ValueSerialization valueSerialization;

    @Before
    public void before() {
        this.module.injectTo((Object)this, new Object[0]);
    }

    @Test
    public void givenCharacterValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)Character.valueOf('q'));
        Assert.assertThat((String)"Serialized", (Object)serialized, (Matcher)IsEqual.equalTo((Object)"q"));
        Character deserialized = (Character)this.valueSerialization.deserialize(Character.class, serialized);
        Assert.assertThat((String)"Deserialized", (Object)deserialized, (Matcher)IsEqual.equalTo((Object)Character.valueOf('q')));
    }

    @Test
    public void givenEmptyStringValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)"");
        Assert.assertThat((String)"Serialized", (Object)serialized, (Matcher)IsEqual.equalTo((Object)""));
        String deserialized = (String)this.valueSerialization.deserialize(String.class, serialized);
        Assert.assertThat((String)"Deserialized", (Object)deserialized, (Matcher)IsEqual.equalTo((Object)""));
    }

    @Test
    public void givenStringValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)"test");
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"test"));
        String deserialized = (String)this.valueSerialization.deserialize(String.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)"test"));
    }

    @Test
    public void givenBooleanValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)Boolean.TRUE);
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"true"));
        Boolean deserialized = (Boolean)this.valueSerialization.deserialize(Boolean.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)Boolean.TRUE));
    }

    @Test
    public void givenIntegerValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)42);
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"42"));
        Integer deserialized = (Integer)this.valueSerialization.deserialize(Integer.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)42));
    }

    @Test
    public void givenLongValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)42L);
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"42"));
        Long deserialized = (Long)this.valueSerialization.deserialize(Long.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)42L));
    }

    @Test
    public void givenShortValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)42);
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"42"));
        Short deserialized = (Short)this.valueSerialization.deserialize(Short.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)42));
    }

    @Test
    public void givenByteValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)42);
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"42"));
        Byte deserialized = (Byte)this.valueSerialization.deserialize(Byte.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)42));
    }

    @Test
    public void givenFloatValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)Float.valueOf(42.0f));
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"42.0"));
        Float deserialized = (Float)this.valueSerialization.deserialize(Float.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)Float.valueOf(42.0f)));
    }

    @Test
    public void givenDoubleValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)42.0);
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"42.0"));
        Double deserialized = (Double)this.valueSerialization.deserialize(Double.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)42.0));
    }

    @Test
    public void givenBigIntegerValueWhenSerializingAndDeserializingExpectEquals() {
        BigInteger bigInteger = new BigInteger("42424242424242424242424242");
        Assert.assertThat((Object)bigInteger, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)BigInteger.valueOf(bigInteger.longValue()))));
        String serialized = this.valueSerialization.serialize((Object)bigInteger);
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"42424242424242424242424242"));
        BigInteger deserialized = (BigInteger)this.valueSerialization.deserialize(BigInteger.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)bigInteger));
    }

    @Test
    public void givenBigDecimalValueWhenSerializingAndDeserializingExpectEquals() {
        BigDecimal bigDecimal = new BigDecimal("42.2376931348623157e+309");
        Assert.assertThat((Object)bigDecimal.doubleValue(), (Matcher)IsEqual.equalTo((Object)Double.POSITIVE_INFINITY));
        String serialized = this.valueSerialization.serialize((Object)bigDecimal);
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"4.22376931348623157E+310"));
        BigDecimal deserialized = (BigDecimal)this.valueSerialization.deserialize(BigDecimal.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)bigDecimal));
    }

    @Test
    public void givenDateValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.forID((String)"CET")).toDate());
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"2020-03-04T12:24:35.000Z"));
        Date deserialized = (Date)this.valueSerialization.deserialize(Date.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.forID((String)"CET")).toDate()));
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)new DateTime((Object)"2020-03-04T12:24:35", DateTimeZone.UTC).toDate()));
    }

    @Test
    public void givenDateTimeValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.forOffsetHours((int)1)));
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"2020-03-04T13:24:35.000+01:00"));
        DateTime deserialized = (DateTime)this.valueSerialization.deserialize(DateTime.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.forOffsetHours((int)1))));
    }

    @Test
    public void givenLocalDateTimeValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)new LocalDateTime((Object)"2020-03-04T13:23:00", DateTimeZone.forID((String)"CET")));
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"2020-03-04T13:23:00.000"));
        LocalDateTime deserialized = (LocalDateTime)this.valueSerialization.deserialize(LocalDateTime.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)new LocalDateTime((Object)"2020-03-04T13:23:00", DateTimeZone.UTC)));
    }

    @Test
    public void givenLocalDateValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)new LocalDate((Object)"2020-03-04"));
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"2020-03-04"));
        LocalDate deserialized = (LocalDate)this.valueSerialization.deserialize(LocalDate.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)new LocalDate((Object)"2020-03-04")));
    }

    @Test
    public void givenEntityReferenceValueWhenSerializingAndDeserializingExpectEquals() {
        String serialized = this.valueSerialization.serialize((Object)EntityReference.parseEntityReference((String)"ABCD-1234"));
        Assert.assertThat((Object)serialized, (Matcher)IsEqual.equalTo((Object)"ABCD-1234"));
        EntityReference deserialized = (EntityReference)this.valueSerialization.deserialize(EntityReference.class, serialized);
        Assert.assertThat((Object)deserialized, (Matcher)IsEqual.equalTo((Object)EntityReference.parseEntityReference((String)"ABCD-1234")));
    }
}

