/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.value;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.UseDefaults;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.test.AbstractQi4jTest;
import org.qi4j.test.EntityTestAssembler;

public abstract class AbstractValueCompositeSerializationTest
extends AbstractQi4jTest {
    @Rule
    public TestName testName = new TestName();
    @Service
    protected ValueSerialization valueSerialization;

    public void assemble(ModuleAssembly module) throws AssemblyException {
        module.values(new Class[]{SomeValue.class, AnotherValue.class, FooValue.class, CustomFooValue.class, SpecificCollection.class});
        ((EntityTestAssembler)((Object)new EntityTestAssembler().visibleIn(Visibility.layer))).assemble(module.layer().module("persistence"));
        module.entities(new Class[]{BarEntity.class});
    }

    @Before
    public void before() {
        this.module.injectTo((Object)this, new Object[0]);
    }

    @Test
    public void givenValueCompositeWhenSerializingAndDeserializingExpectEquals() throws Exception {
        UnitOfWork uow = this.module.newUnitOfWork();
        try {
            SomeValue some = this.buildSomeValue();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.valueSerialization.serialize((Object)some, (OutputStream)output);
            String stateString = output.toString("UTF-8");
            SomeValue some2 = (SomeValue)this.module.newValueFromSerializedState(SomeValue.class, stateString);
            Assert.assertThat((String)"Same value toString", (Object)some.toString(), (Matcher)CoreMatchers.equalTo((Object)some2.toString()));
            Assert.assertThat((String)"Same value", (Object)some, (Matcher)CoreMatchers.equalTo((Object)some2));
            Assert.assertThat((String)"Same JSON value toString", (Object)stateString, (Matcher)CoreMatchers.equalTo((Object)some2.toString()));
            Assert.assertThat((String)"Same JSON value", (Object)(some.customFoo().get() instanceof CustomFooValue), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((String)"Same JSON value explicit", (Object)(some.customFooValue().get() instanceof CustomFooValue), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((String)"String Integer Map", ((Map)some2.stringIntMap().get()).get("foo"), (Matcher)CoreMatchers.equalTo((Object)42));
            Assert.assertThat((String)"String Value Map", (Object)((AnotherValue)((Map)some2.stringValueMap().get()).get("foo")).internalVal(), (Matcher)CoreMatchers.equalTo((Object)"Bar"));
            Assert.assertThat((String)"Nested Entities", (Object)((Bar)some2.barAssociation().get()).cathedral().get(), (Matcher)CoreMatchers.equalTo((Object)"bazar in barAssociation"));
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            uow.discard();
        }
    }

    private SomeValue buildSomeValue() {
        ValueBuilder builder = this.module.newValueBuilder(SomeValue.class);
        SomeValue proto = (SomeValue)builder.prototype();
        ((List)proto.anotherList().get()).add(this.module.newValue(AnotherValue.class));
        ValueBuilder specificColBuilder = this.module.newValueBuilder(SpecificCollection.class);
        SpecificCollection specificColProto = (SpecificCollection)specificColBuilder.prototype();
        ArrayList<String> genericList = new ArrayList<String>(2);
        genericList.add("Some");
        genericList.add("String");
        specificColProto.genericList().set(genericList);
        proto.specificCollection().set(specificColBuilder.newInstance());
        AnotherValue anotherValue1 = this.createAnotherValue("Foo", "Bar");
        AnotherValue anotherValue2 = this.createAnotherValue("Habba", "ZoutZout");
        AnotherValue anotherValue3 = this.createAnotherValue("Niclas", "Hedhman");
        proto.string().set((Object)"Foo\"Bar\"\nTest\t");
        proto.string2().set((Object)"/Foo/bar");
        proto.number().set((Object)42L);
        proto.date().set((Object)new Date());
        proto.dateTime().set((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.forOffsetHours((int)1)));
        proto.localDate().set((Object)new LocalDate());
        proto.localDateTime().set((Object)new LocalDateTime());
        proto.entityReference().set((Object)EntityReference.parseEntityReference((String)"12345"));
        ((Map)proto.stringIntMap().get()).put("foo", 42);
        ((Map)proto.stringValueMap().get()).put("foo", anotherValue1);
        proto.another().set((Object)anotherValue1);
        proto.serializable().set((Object)new SerializableObject());
        proto.foo().set(this.module.newValue(FooValue.class));
        proto.fooValue().set(this.module.newValue(FooValue.class));
        proto.customFoo().set(this.module.newValue(CustomFooValue.class));
        proto.customFooValue().set(this.module.newValue(CustomFooValue.class));
        proto.barAssociation().set((Object)this.buildBarEntity("bazar in barAssociation"));
        proto.barEntityAssociation().set((Object)this.buildBarEntity("bazar in barEntityAssociation"));
        proto.barManyAssociation().add((Object)this.buildBarEntity("bazar ONE in barManyAssociation"));
        proto.barManyAssociation().add((Object)this.buildBarEntity("bazar TWO in barManyAssociation"));
        proto.barEntityManyAssociation().add((Object)this.buildBarEntity("bazar ONE in barEntityManyAssociation"));
        proto.barEntityManyAssociation().add((Object)this.buildBarEntity("bazar TWO in barEntityManyAssociation"));
        proto.barNamedAssociation().put("bazar", (Object)this.buildBarEntity("bazar in barNamedAssociation"));
        proto.barNamedAssociation().put("cathedral", (Object)this.buildBarEntity("cathedral in barNamedAssociation"));
        proto.barEntityNamedAssociation().put("bazar", (Object)this.buildBarEntity("bazar in barEntityNamedAssociation"));
        proto.barEntityNamedAssociation().put("cathedral", (Object)this.buildBarEntity("cathedral in barEntityNamedAssociation"));
        return (SomeValue)builder.newInstance();
    }

    private AnotherValue createAnotherValue(String val1, String val2) {
        ValueBuilder valueBuilder = this.module.newValueBuilder(AnotherValue.class);
        ((AnotherValue)valueBuilder.prototype()).val1().set((Object)val1);
        ((AnotherValueInternalState)valueBuilder.prototypeFor(AnotherValueInternalState.class)).val2().set((Object)val2);
        return (AnotherValue)valueBuilder.newInstance();
    }

    private BarEntity buildBarEntity(String cathedral) {
        EntityBuilder barBuilder = this.module.currentUnitOfWork().newEntityBuilder(BarEntity.class);
        ((BarEntity)barBuilder.instance()).cathedral().set((Object)cathedral);
        return (BarEntity)barBuilder.newInstance();
    }

    public static class SerializableObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String foo = "Foo";
        private final int val = 35;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializableObject that = (SerializableObject)o;
            return 35 == that.val && "Foo".equals(that.foo);
        }

        public int hashCode() {
            int result = "Foo".hashCode();
            result = 31 * result + 35;
            return result;
        }
    }

    public static interface BarEntity
    extends Bar,
    EntityComposite {
    }

    public static interface Bar {
        @UseDefaults
        public Property<String> cathedral();
    }

    public static interface CustomFooValue
    extends FooValue {
        @UseDefaults
        public Property<String> custom();
    }

    public static interface FooValue
    extends Foo,
    ValueComposite {
    }

    public static interface Foo {
        @UseDefaults
        public Property<String> bar();
    }

    public static abstract class AnotherValueMixin
    implements AnotherValue {
        @This
        private AnotherValueInternalState internalState;

        @Override
        public String internalVal() {
            return (String)this.internalState.val2().get();
        }
    }

    public static interface AnotherValueInternalState {
        @UseDefaults
        public Property<String> val2();
    }

    @Mixins(value={AnotherValueMixin.class})
    public static interface AnotherValue
    extends ValueComposite {
        @UseDefaults
        public Property<String> val1();

        public String internalVal();
    }

    public static interface GenericValue<TYPE>
    extends ValueComposite {
        @Optional
        public Property<TYPE> item();
    }

    public static interface SpecificValue
    extends GenericValue<String> {
    }

    public static interface GenericCollection<TYPE>
    extends ValueComposite {
        @UseDefaults
        public Property<List<TYPE>> genericList();
    }

    public static interface SpecificCollection
    extends GenericCollection<String> {
    }

    public static interface SomeValue
    extends ValueComposite {
        public Property<String> string();

        public Property<String> string2();

        @Optional
        public Property<String> nullString();

        @UseDefaults
        public Property<String> emptyString();

        @UseDefaults
        public Property<Long> number();

        public Property<Date> date();

        public Property<DateTime> dateTime();

        public Property<LocalDate> localDate();

        public Property<LocalDateTime> localDateTime();

        public Property<EntityReference> entityReference();

        @UseDefaults
        public Property<List<String>> stringList();

        @UseDefaults
        public Property<Map<String, Integer>> stringIntMap();

        @UseDefaults
        public Property<Map<String, AnotherValue>> stringValueMap();

        public Property<AnotherValue> another();

        @Optional
        public Property<AnotherValue> anotherNull();

        @UseDefaults
        public Property<List<AnotherValue>> anotherList();

        @Optional
        public Property<List<AnotherValue>> anotherListNull();

        @UseDefaults
        public Property<List<AnotherValue>> anotherListEmpty();

        @UseDefaults
        public Property<TestEnum> testEnum();

        public Property<Object> serializable();

        public Property<Foo> foo();

        public Property<FooValue> fooValue();

        public Property<Foo> customFoo();

        public Property<FooValue> customFooValue();

        public Property<SpecificCollection> specificCollection();

        @Optional
        public Association<Bar> barAssociationOptional();

        public Association<Bar> barAssociation();

        public Association<BarEntity> barEntityAssociation();

        public ManyAssociation<Bar> barManyAssociationEmpty();

        public ManyAssociation<Bar> barManyAssociation();

        public ManyAssociation<BarEntity> barEntityManyAssociation();

        public NamedAssociation<Bar> barNamedAssociationEmpty();

        public NamedAssociation<Bar> barNamedAssociation();

        public NamedAssociation<BarEntity> barEntityNamedAssociation();
    }

    public static enum TestEnum {
        somevalue,
        anothervalue;

    }
}

