/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.shiro.concerns;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.PermissionUtils;
import org.qi4j.api.common.AppliesTo;
import org.qi4j.api.common.Optional;
import org.qi4j.api.concern.ConcernOf;
import org.qi4j.api.injection.scope.Invocation;
import org.qi4j.library.shiro.Shiro;
import org.qi4j.library.shiro.concerns.RequiresAuthentication;
import org.qi4j.library.shiro.concerns.RequiresGuest;
import org.qi4j.library.shiro.concerns.RequiresPermissions;
import org.qi4j.library.shiro.concerns.RequiresRoles;
import org.qi4j.library.shiro.concerns.RequiresUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AppliesTo(value={RequiresAuthentication.class, RequiresGuest.class, RequiresPermissions.class, RequiresRoles.class, RequiresUser.class})
public class SecurityConcern
extends ConcernOf<InvocationHandler>
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Shiro.LOGGER_NAME);
    @Optional
    @Invocation
    private RequiresAuthentication requiresAuthentication;
    @Optional
    @Invocation
    private RequiresGuest requiresGuest;
    @Optional
    @Invocation
    private RequiresPermissions requiresPermissions;
    @Optional
    @Invocation
    private RequiresRoles requiresRoles;
    @Optional
    @Invocation
    private RequiresUser requiresUser;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Subject subject = SecurityUtils.getSubject();
        this.handleRequiresGuest(subject);
        this.handleRequiresUser(subject);
        this.handleRequiresAuthentication(subject);
        this.handleRequiresRoles(subject);
        this.handleRequiresPermissions(subject);
        return ((InvocationHandler)this.next).invoke(proxy, method, args);
    }

    private void handleRequiresGuest(Subject subject) {
        if (this.requiresGuest != null) {
            LOGGER.debug("SecurityConcern::RequiresGuest");
            if (subject.getPrincipal() != null) {
                throw new UnauthenticatedException("Attempting to perform a guest-only operation. The current Subject is not a guest (they have been authenticated or remembered from a previous login).  Access denied.");
            }
        } else {
            LOGGER.debug("SecurityConcern::RequiresGuest: not concerned");
        }
    }

    private void handleRequiresUser(Subject subject) {
        if (this.requiresUser != null) {
            LOGGER.debug("SecurityConcern::RequiresUser");
            if (subject.getPrincipal() == null) {
                throw new UnauthenticatedException("Attempting to perform a user-only operation. The current Subject is not a user (they haven't been authenticated or remembered from a previous login).  Access denied.");
            }
        } else {
            LOGGER.debug("SecurityConcern::RequiresUser: not concerned");
        }
    }

    private void handleRequiresAuthentication(Subject subject) {
        if (this.requiresAuthentication != null) {
            LOGGER.debug("SecurityConcern::RequiresAuthentication");
            if (!subject.isAuthenticated()) {
                throw new UnauthenticatedException("The current Subject is not authenticated.  Access denied.");
            }
        } else {
            LOGGER.debug("SecurityConcern::RequiresAuthentication: not concerned");
        }
    }

    private void handleRequiresRoles(Subject subject) {
        if (this.requiresRoles != null) {
            LOGGER.debug("SecurityConcern::RequiresRoles");
            String roleId = this.requiresRoles.value();
            String[] roles = roleId.split(",");
            if (roles.length == 1) {
                if (!subject.hasRole(roles[0])) {
                    String msg = "Calling Subject does not have required role [" + roleId + "].  " + "MethodInvocation denied.";
                    throw new UnauthorizedException(msg);
                }
            } else {
                LinkedHashSet<String> rolesSet = new LinkedHashSet<String>(Arrays.asList(roles));
                if (!subject.hasAllRoles(rolesSet)) {
                    String msg = "Calling Subject does not have required roles [" + roleId + "].  " + "MethodInvocation denied.";
                    throw new UnauthorizedException(msg);
                }
            }
        } else {
            LOGGER.debug("SecurityConcern::RequiresRoles: not concerned");
        }
    }

    private void handleRequiresPermissions(Subject subject) {
        if (this.requiresPermissions != null) {
            LOGGER.debug("SecurityConcern::RequiresPermissions");
            String permsString = this.requiresPermissions.value();
            Set permissions = PermissionUtils.toPermissionStrings((String)permsString);
            if (permissions.size() == 1) {
                if (!subject.isPermitted((String)permissions.iterator().next())) {
                    String msg = "Calling Subject does not have required permission [" + permsString + "].  " + "Method invocation denied.";
                    throw new UnauthorizedException(msg);
                }
            } else {
                String[] permStrings = new String[permissions.size()];
                if (!subject.isPermittedAll(permStrings = permissions.toArray(permStrings))) {
                    String msg = "Calling Subject does not have required permissions [" + permsString + "].  " + "Method invocation denied.";
                    throw new UnauthorizedException(msg);
                }
            }
        } else {
            LOGGER.debug("SecurityConcern::RequiresPermissions: not concerned");
        }
    }
}

