/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.shiro.domain.permissions;

import java.util.Arrays;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.functional.Iterables;
import org.qi4j.library.shiro.domain.permissions.Role;

@Mixins(value={Mixin.class})
public interface RoleFactory
extends ServiceComposite {
    public Role create(String var1, String ... var2);

    public Role create(String var1, Iterable<String> var2);

    public static abstract class Mixin
    implements RoleFactory {
        @Structure
        private Module module;

        @Override
        public Role create(String name, String ... permissions) {
            return this.create(name, Arrays.asList(permissions));
        }

        @Override
        public Role create(String name, Iterable<String> permissions) {
            UnitOfWork uow = this.module.currentUnitOfWork();
            EntityBuilder roleBuilder = uow.newEntityBuilder(Role.class);
            Role role = (Role)roleBuilder.instance();
            role.name().set((Object)name);
            role.permissions().set((Object)Iterables.toList(permissions));
            return (Role)roleBuilder.newInstance();
        }
    }
}

