/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.shiro.ini;

import java.util.ArrayList;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.util.ThreadContext;
import org.qi4j.api.common.Optional;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.functional.Iterables;
import org.qi4j.library.shiro.Shiro;
import org.qi4j.library.shiro.ini.ShiroIniConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
public interface IniSecurityManagerService
extends ServiceActivation {
    public SecurityManager getSecurityManager();

    public static class Mixin
    extends IniSecurityManagerFactory
    implements IniSecurityManagerService {
        private static final Logger LOG = LoggerFactory.getLogger((String)Shiro.LOGGER_NAME);
        @This
        private Configuration<ShiroIniConfiguration> configuration;
        @Optional
        @Service
        private Iterable<ServiceReference<Realm>> realmsRefs;
        private SecurityManager securityManager;

        public void activateService() throws Exception {
            this.configuration.refresh();
            ShiroIniConfiguration config = (ShiroIniConfiguration)this.configuration.get();
            String iniResourcePath = config.iniResourcePath().get() == null ? "classpath:shiro.ini" : (String)config.iniResourcePath().get();
            this.setIni(Ini.fromResourcePath((String)iniResourcePath));
            this.securityManager = (SecurityManager)this.getInstance();
            if (this.realmsRefs != null && Iterables.count(this.realmsRefs) > 0L) {
                RealmSecurityManager realmSecurityManager = (RealmSecurityManager)this.securityManager;
                ArrayList<Object> iniRealms = new ArrayList<Object>(realmSecurityManager.getRealms());
                for (ServiceReference<Realm> realmRef : this.realmsRefs) {
                    iniRealms.add(realmRef.get());
                    LOG.debug("Realm Service '{}' registered!", (Object)realmRef.identity());
                }
                realmSecurityManager.setRealms(iniRealms);
            }
            ThreadContext.bind((SecurityManager)this.securityManager);
        }

        public void passivateService() throws Exception {
            ThreadContext.unbindSubject();
            ThreadContext.unbindSecurityManager();
        }

        @Override
        public SecurityManager getSecurityManager() {
            return this.securityManager;
        }
    }
}

