/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.activation;

import java.util.Collections;
import java.util.LinkedHashSet;
import org.qi4j.api.activation.Activator;
import org.qi4j.api.activation.PassivationException;
import org.qi4j.functional.Iterables;

public class ActivatorsInstance<ActivateeType>
implements Activator<ActivateeType> {
    public static final ActivatorsInstance EMPTY = new ActivatorsInstance(Collections.emptyList());
    private final Iterable<Activator<ActivateeType>> activators;

    public ActivatorsInstance(Iterable<Activator<ActivateeType>> activators) {
        this.activators = activators;
    }

    public void beforeActivation(ActivateeType activating) throws Exception {
        for (Activator<ActivateeType> activator : this.activators) {
            activator.beforeActivation(activating);
        }
    }

    public void afterActivation(ActivateeType activated) throws Exception {
        for (Activator<ActivateeType> activator : this.activators) {
            activator.afterActivation(activated);
        }
    }

    public void beforePassivation(ActivateeType passivating) throws Exception {
        LinkedHashSet<Exception> exceptions = new LinkedHashSet<Exception>();
        for (Activator activator : Iterables.reverse(this.activators)) {
            try {
                activator.beforePassivation(passivating);
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new PassivationException(exceptions);
        }
    }

    public void afterPassivation(ActivateeType passivated) throws Exception {
        LinkedHashSet<Exception> exceptions = new LinkedHashSet<Exception>();
        for (Activator activator : Iterables.reverse(this.activators)) {
            try {
                activator.afterPassivation(passivated);
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new PassivationException(exceptions);
        }
    }
}

