/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qi4j.api.activation.Activator;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.structure.Application;
import org.qi4j.bootstrap.ApplicationAssembly;
import org.qi4j.bootstrap.AssemblyVisitor;
import org.qi4j.bootstrap.LayerAssembly;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.runtime.bootstrap.LayerAssemblyImpl;

public final class ApplicationAssemblyImpl
implements ApplicationAssembly {
    private final Map<String, LayerAssemblyImpl> layerAssemblies = new LinkedHashMap<String, LayerAssemblyImpl>();
    private String name = "Application";
    private String version = "1.0";
    private Application.Mode mode;
    private final MetaInfo metaInfo = new MetaInfo();
    private final List<Class<? extends Activator<Application>>> activators = new ArrayList<Class<? extends Activator<Application>>>();

    public ApplicationAssemblyImpl() {
        this.mode = Application.Mode.valueOf((String)System.getProperty("mode", "production"));
    }

    public LayerAssembly layer(String name) {
        LayerAssemblyImpl existing;
        if (name != null && (existing = this.layerAssemblies.get(name)) != null) {
            return existing;
        }
        LayerAssemblyImpl layerAssembly = new LayerAssemblyImpl(this, name);
        this.layerAssemblies.put(name, layerAssembly);
        return layerAssembly;
    }

    public ModuleAssembly module(String layerName, String moduleName) {
        return this.layer(layerName).module(moduleName);
    }

    public ApplicationAssembly setName(String name) {
        this.name = name;
        return this;
    }

    public ApplicationAssembly setVersion(String version) {
        this.version = version;
        return this;
    }

    public ApplicationAssembly setMode(Application.Mode mode) {
        this.mode = mode;
        return this;
    }

    public ApplicationAssembly setMetaInfo(Object info) {
        this.metaInfo.set(info);
        return this;
    }

    @SafeVarargs
    public final ApplicationAssembly withActivators(Class<? extends Activator<Application>> ... activators) {
        this.activators.addAll(Arrays.asList(activators));
        return this;
    }

    public <ThrowableType extends Throwable> void visit(AssemblyVisitor<ThrowableType> visitor) throws ThrowableType {
        visitor.visitApplication((ApplicationAssembly)this);
        for (LayerAssemblyImpl layerAssembly : this.layerAssemblies.values()) {
            layerAssembly.visit(visitor);
        }
    }

    public Collection<LayerAssemblyImpl> layerAssemblies() {
        return this.layerAssemblies.values();
    }

    public List<Class<? extends Activator<Application>>> activators() {
        return this.activators;
    }

    public MetaInfo metaInfo() {
        return this.metaInfo;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public Application.Mode mode() {
        return this.mode;
    }
}

