/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.qi4j.api.composite.ModelDescriptor;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.api.structure.Layer;
import org.qi4j.bootstrap.ApplicationAssembly;
import org.qi4j.bootstrap.ApplicationModelFactory;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.BindingException;
import org.qi4j.bootstrap.LayerAssembly;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.runtime.activation.ActivatorsModel;
import org.qi4j.runtime.bootstrap.ApplicationAssemblyImpl;
import org.qi4j.runtime.bootstrap.AssemblyHelper;
import org.qi4j.runtime.bootstrap.LayerAssemblyImpl;
import org.qi4j.runtime.bootstrap.ModuleAssemblyImpl;
import org.qi4j.runtime.composite.CompositeMethodModel;
import org.qi4j.runtime.injection.InjectedFieldModel;
import org.qi4j.runtime.model.Binder;
import org.qi4j.runtime.model.Resolution;
import org.qi4j.runtime.structure.ApplicationModel;
import org.qi4j.runtime.structure.LayerModel;
import org.qi4j.runtime.structure.ModuleModel;
import org.qi4j.runtime.structure.UsedLayersModel;

public final class ApplicationModelFactoryImpl
implements ApplicationModelFactory {
    public ApplicationDescriptor newApplicationModel(ApplicationAssembly assembly) throws AssemblyException {
        AssemblyHelper helper = new AssemblyHelper();
        ApplicationAssemblyImpl applicationAssembly = (ApplicationAssemblyImpl)assembly;
        ActivatorsModel<Application> applicationActivators = new ActivatorsModel<Application>(applicationAssembly.activators());
        ArrayList<LayerModel> layerModels = new ArrayList<LayerModel>();
        ApplicationModel applicationModel = new ApplicationModel(applicationAssembly.name(), applicationAssembly.version(), applicationAssembly.mode(), applicationAssembly.metaInfo(), applicationActivators, layerModels);
        HashMap<LayerAssemblyImpl, LayerModel> mapAssemblyModel = new HashMap<LayerAssemblyImpl, LayerModel>();
        HashMap<LayerAssemblyImpl, ArrayList<LayerModel>> mapUsedLayers = new HashMap<LayerAssemblyImpl, ArrayList<LayerModel>>();
        ArrayList<LayerAssemblyImpl> layerAssemblies = new ArrayList<LayerAssemblyImpl>(applicationAssembly.layerAssemblies());
        for (LayerAssemblyImpl layerAssembly : layerAssemblies) {
            ArrayList<LayerModel> usedLayers = new ArrayList<LayerModel>();
            mapUsedLayers.put(layerAssembly, usedLayers);
            UsedLayersModel usedLayersModel = new UsedLayersModel(usedLayers);
            ArrayList<ModuleModel> moduleModels = new ArrayList<ModuleModel>();
            String name = layerAssembly.name();
            if (name == null) {
                throw new AssemblyException("Layer must have name set");
            }
            ActivatorsModel<Layer> layerActivators = new ActivatorsModel<Layer>(layerAssembly.activators());
            LayerModel layerModel = new LayerModel(name, layerAssembly.metaInfo(), usedLayersModel, layerActivators, moduleModels);
            for (ModuleAssemblyImpl moduleAssembly : layerAssembly.moduleAssemblies()) {
                moduleModels.add(moduleAssembly.assembleModule(helper));
            }
            mapAssemblyModel.put(layerAssembly, layerModel);
            layerModels.add(layerModel);
        }
        for (LayerAssemblyImpl layerAssembly : layerAssemblies) {
            Set<LayerAssembly> usesLayers = layerAssembly.uses();
            List usedLayers = (List)mapUsedLayers.get(layerAssembly);
            for (LayerAssembly usesLayer : usesLayers) {
                LayerModel layerModel = (LayerModel)mapAssemblyModel.get(usesLayer);
                usedLayers.add(layerModel);
            }
        }
        try {
            applicationModel.accept(new BindingVisitor(applicationModel));
        }
        catch (BindingException e) {
            throw new AssemblyException("Unable to bind: " + applicationModel, (Throwable)e);
        }
        return applicationModel;
    }

    private static class BindingVisitor
    implements HierarchicalVisitor<Object, Object, BindingException> {
        private LayerModel layer;
        private ModuleModel module;
        private ModelDescriptor objectDescriptor;
        private CompositeMethodModel compositeMethodModel;
        private Resolution resolution;
        private final ApplicationModel applicationModel;

        private BindingVisitor(ApplicationModel applicationModel) {
            this.applicationModel = applicationModel;
        }

        public boolean visitEnter(Object visited) throws BindingException {
            if (visited instanceof Binder) {
                Binder binder = (Binder)visited;
                binder.bind(this.resolution);
                return false;
            }
            if (visited instanceof CompositeMethodModel) {
                this.compositeMethodModel = (CompositeMethodModel)visited;
                this.resolution = new Resolution(this.applicationModel, this.layer, this.module, this.objectDescriptor, this.compositeMethodModel, null);
            } else if (visited instanceof ModelDescriptor) {
                this.objectDescriptor = (ModelDescriptor)visited;
                this.resolution = new Resolution(this.applicationModel, this.layer, this.module, this.objectDescriptor, null, null);
            } else if (visited instanceof InjectedFieldModel) {
                InjectedFieldModel fieldModel = (InjectedFieldModel)visited;
                fieldModel.bind(new Resolution(this.applicationModel, this.layer, this.module, this.objectDescriptor, this.compositeMethodModel, fieldModel.field()));
            } else if (visited instanceof ModuleModel) {
                this.module = (ModuleModel)visited;
            } else if (visited instanceof LayerModel) {
                this.layer = (LayerModel)visited;
            }
            return true;
        }

        public boolean visitLeave(Object visited) throws BindingException {
            return true;
        }

        public boolean visit(Object visited) throws BindingException {
            if (visited instanceof Binder) {
                ((Binder)visited).bind(this.resolution);
            }
            return true;
        }
    }
}

