/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.qi4j.api.common.AppliesTo;
import org.qi4j.api.common.AppliesToFilter;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.constraint.Constraint;
import org.qi4j.runtime.bootstrap.AndAppliesToFilter;
import org.qi4j.runtime.bootstrap.AnnotationAppliesToFilter;
import org.qi4j.runtime.bootstrap.ImplementsMethodAppliesToFilter;
import org.qi4j.runtime.bootstrap.OrAppliesToFilter;
import org.qi4j.runtime.bootstrap.TypeCheckAppliesToFilter;
import org.qi4j.runtime.bootstrap.TypedFragmentAppliesToFilter;
import org.qi4j.runtime.composite.ConcernModel;
import org.qi4j.runtime.composite.ConstraintDeclaration;
import org.qi4j.runtime.composite.FragmentClassLoader;
import org.qi4j.runtime.composite.MixinModel;
import org.qi4j.runtime.composite.SideEffectModel;

public class AssemblyHelper {
    Map<Class, Class> instantiationClasses = new HashMap<Class, Class>();
    Map<Class, ConstraintDeclaration> constraintDeclarations = new HashMap<Class, ConstraintDeclaration>();
    Map<ClassLoader, FragmentClassLoader> modifierClassLoaders = new HashMap<ClassLoader, FragmentClassLoader>();
    Map<Class<?>, AppliesToFilter> appliesToInstances = new HashMap();

    public MixinModel getMixinModel(Class mixinClass) {
        return new MixinModel(mixinClass, this.instantiationClass(mixinClass));
    }

    public ConcernModel getConcernModel(Class concernClass) {
        return new ConcernModel(concernClass, this.instantiationClass(concernClass));
    }

    public SideEffectModel getSideEffectModel(Class sideEffectClass) {
        return new SideEffectModel(sideEffectClass, this.instantiationClass(sideEffectClass));
    }

    private Class instantiationClass(Class fragmentClass) {
        Class instantiationClass = fragmentClass;
        if (!InvocationHandler.class.isAssignableFrom(fragmentClass) && (instantiationClass = this.instantiationClasses.get(fragmentClass)) == null) {
            try {
                FragmentClassLoader fragmentLoader = this.getModifierClassLoader(fragmentClass.getClassLoader());
                instantiationClass = fragmentLoader.loadFragmentClass(fragmentClass);
                this.instantiationClasses.put(fragmentClass, instantiationClass);
            }
            catch (ClassNotFoundException | VerifyError e) {
                throw new ConstructionException("Could not generate mixin subclass " + fragmentClass.getName(), e);
            }
        }
        return instantiationClass;
    }

    private FragmentClassLoader getModifierClassLoader(ClassLoader classLoader) {
        FragmentClassLoader cl = this.modifierClassLoaders.get(classLoader);
        if (cl == null) {
            cl = new FragmentClassLoader(classLoader);
            this.modifierClassLoaders.put(classLoader, cl);
        }
        return cl;
    }

    public boolean appliesTo(Class<?> fragmentClass, Method method, Iterable<Class<?>> types, Class<?> mixinClass) {
        AppliesToFilter appliesToFilter = this.appliesToInstances.get(fragmentClass);
        if (appliesToFilter == null) {
            appliesToFilter = this.createAppliesToFilter(fragmentClass);
            this.appliesToInstances.put(fragmentClass, appliesToFilter);
        }
        for (Class<?> compositeType : types) {
            if (!appliesToFilter.appliesTo(method, mixinClass, compositeType, fragmentClass)) continue;
            return true;
        }
        return false;
    }

    public AppliesToFilter createAppliesToFilter(Class<?> fragmentClass) {
        Object result = null;
        if (!InvocationHandler.class.isAssignableFrom(fragmentClass)) {
            result = new TypedFragmentAppliesToFilter();
            if (Modifier.isAbstract(fragmentClass.getModifiers())) {
                result = new AndAppliesToFilter((AppliesToFilter)result, new ImplementsMethodAppliesToFilter());
            }
        }
        if ((result = this.applyAppliesTo((AppliesToFilter)result, fragmentClass)) == null) {
            return AppliesToFilter.ALWAYS;
        }
        return result;
    }

    private AppliesToFilter applyAppliesTo(AppliesToFilter existing, Class<?> modifierClass) {
        AppliesTo appliesTo = modifierClass.getAnnotation(AppliesTo.class);
        if (appliesTo != null) {
            Object appliesToAnnotation = null;
            for (Class appliesToClass : appliesTo.value()) {
                Object filter;
                if (AppliesToFilter.class.isAssignableFrom(appliesToClass)) {
                    try {
                        filter = (AppliesToFilter)appliesToClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new ConstructionException((Throwable)e);
                    }
                } else {
                    filter = Annotation.class.isAssignableFrom(appliesToClass) ? new AnnotationAppliesToFilter(appliesToClass) : new TypeCheckAppliesToFilter(appliesToClass);
                }
                appliesToAnnotation = appliesToAnnotation == null ? filter : new OrAppliesToFilter((AppliesToFilter)appliesToAnnotation, (AppliesToFilter)filter);
            }
            if (existing == null) {
                return appliesToAnnotation;
            }
            return new AndAppliesToFilter(existing, (AppliesToFilter)appliesToAnnotation);
        }
        return existing;
    }

    public boolean appliesTo(Class<? extends Constraint<?, ?>> constraint, Class<? extends Annotation> annotationType, Type valueType) {
        ConstraintDeclaration constraintDeclaration = this.constraintDeclarations.get(constraint);
        if (constraintDeclaration == null) {
            constraintDeclaration = new ConstraintDeclaration(constraint);
            this.constraintDeclarations.put(constraint, constraintDeclaration);
        }
        return constraintDeclaration.appliesTo(annotationType, valueType);
    }
}

