/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.common.UseDefaults;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.composite.InvalidCompositeException;
import org.qi4j.api.concern.Concerns;
import org.qi4j.api.constraint.Constraint;
import org.qi4j.api.constraint.ConstraintDeclaration;
import org.qi4j.api.constraint.Constraints;
import org.qi4j.api.constraint.Name;
import org.qi4j.api.entity.Lifecycle;
import org.qi4j.api.injection.scope.State;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Initializable;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.GenericPropertyInfo;
import org.qi4j.api.property.Immutable;
import org.qi4j.api.property.Property;
import org.qi4j.api.sideeffect.SideEffects;
import org.qi4j.api.type.HasTypes;
import org.qi4j.api.util.Annotations;
import org.qi4j.api.util.Classes;
import org.qi4j.api.util.Fields;
import org.qi4j.bootstrap.StateDeclarations;
import org.qi4j.functional.ForEach;
import org.qi4j.functional.Function;
import org.qi4j.functional.HierarchicalVisitorAdapter;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.functional.Visitor;
import org.qi4j.runtime.bootstrap.AssemblyHelper;
import org.qi4j.runtime.composite.AbstractConstraintModel;
import org.qi4j.runtime.composite.CompositeConstraintModel;
import org.qi4j.runtime.composite.CompositeMethodModel;
import org.qi4j.runtime.composite.CompositeMethodsModel;
import org.qi4j.runtime.composite.ConcernModel;
import org.qi4j.runtime.composite.ConcernsModel;
import org.qi4j.runtime.composite.ConstraintModel;
import org.qi4j.runtime.composite.ConstraintsModel;
import org.qi4j.runtime.composite.GenericSpecification;
import org.qi4j.runtime.composite.MixinModel;
import org.qi4j.runtime.composite.MixinsModel;
import org.qi4j.runtime.composite.SideEffectModel;
import org.qi4j.runtime.composite.SideEffectsModel;
import org.qi4j.runtime.composite.StateModel;
import org.qi4j.runtime.composite.ValueConstraintsInstance;
import org.qi4j.runtime.composite.ValueConstraintsModel;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.property.PropertiesModel;
import org.qi4j.runtime.property.PropertyModel;

public abstract class CompositeAssemblyImpl
implements HasTypes {
    protected List<Class<?>> concerns = new ArrayList();
    protected List<Class<?>> sideEffects = new ArrayList();
    protected List<Class<?>> mixins = new ArrayList();
    protected List<Class<?>> types = new ArrayList();
    protected MetaInfo metaInfo = new MetaInfo();
    protected Visibility visibility = Visibility.module;
    protected boolean immutable;
    protected PropertiesModel propertiesModel;
    protected StateModel stateModel;
    protected MixinsModel mixinsModel;
    protected CompositeMethodsModel compositeMethodsModel;
    private AssemblyHelper helper;
    protected StateDeclarations stateDeclarations;
    protected Set<String> registeredStateNames = new HashSet<String>();

    public CompositeAssemblyImpl(Class<?> mainType) {
        this.types.add(mainType);
    }

    public Iterable<Class<?>> types() {
        return this.types;
    }

    protected StateModel createStateModel() {
        return new StateModel(this.propertiesModel);
    }

    protected MixinsModel createMixinsModel() {
        return new MixinsModel();
    }

    protected void buildComposite(AssemblyHelper helper, StateDeclarations stateDeclarations) {
        this.stateDeclarations = stateDeclarations;
        this.helper = helper;
        for (Class<?> compositeType : this.types) {
            this.metaInfo = new MetaInfo(this.metaInfo).withAnnotations(compositeType);
            this.addAnnotationsMetaInfo(compositeType, this.metaInfo);
        }
        this.immutable = this.metaInfo.get(Immutable.class) != null;
        this.propertiesModel = new PropertiesModel();
        this.stateModel = this.createStateModel();
        this.mixinsModel = this.createMixinsModel();
        this.compositeMethodsModel = new CompositeMethodsModel(this.mixinsModel);
        ArrayList<Type> allTypes = this.getTypes(this.types);
        Iterable<Class<? extends Constraint<?, ?>>> constraintClasses = this.constraintDeclarations(this.getTypes(this.types));
        Iterable concernClasses = Iterables.flatten((Iterable[])new Iterable[]{this.concerns, this.concernDeclarations(allTypes)});
        Iterable sideEffectClasses = Iterables.flatten((Iterable[])new Iterable[]{this.sideEffects, this.sideEffectDeclarations(allTypes)});
        Iterable mixinClasses = Iterables.flatten((Iterable[])new Iterable[]{this.mixins, this.mixinDeclarations(this.types)});
        this.implementMixinType(this.types, constraintClasses, concernClasses, sideEffectClasses, mixinClasses);
        this.addState(constraintClasses);
    }

    protected void addAnnotationsMetaInfo(Class<?> type, MetaInfo compositeMetaInfo) {
        Class<?>[] declaredInterfaces = type.getInterfaces();
        for (int i = declaredInterfaces.length - 1; i >= 0; --i) {
            this.addAnnotationsMetaInfo(declaredInterfaces[i], compositeMetaInfo);
        }
        compositeMetaInfo.withAnnotations(type);
    }

    protected void implementMixinType(Iterable<? extends Class<?>> types, Iterable<Class<? extends Constraint<?, ?>>> constraintClasses, Iterable<Class<?>> concernClasses, Iterable<Class<?>> sideEffectClasses, Iterable<Class<?>> mixinClasses) {
        HashSet thisDependencies = new HashSet();
        for (Class<?> mixinType : types) {
            for (Method method : mixinType.getMethods()) {
                if (this.compositeMethodsModel.isImplemented(method) || Proxy.class.equals(method.getDeclaringClass().getSuperclass()) || Proxy.class.equals(method.getDeclaringClass()) || Modifier.isStatic(method.getModifiers())) continue;
                MixinModel mixinModel = this.implementMethod(method, mixinClasses);
                ConcernsModel concernsModel = this.concernsFor(method, mixinModel.mixinClass(), Iterables.flatten((Iterable[])new Iterable[]{this.concernDeclarations(mixinModel.mixinClass()), concernClasses}));
                SideEffectsModel sideEffectsModel = this.sideEffectsFor(method, mixinModel.mixinClass(), Iterables.flatten((Iterable[])new Iterable[]{this.sideEffectDeclarations(mixinModel.mixinClass()), sideEffectClasses}));
                method.setAccessible(true);
                ConstraintsModel constraints = this.constraintsFor(method, Iterables.flatten((Iterable[])new Iterable[]{this.constraintDeclarations(mixinModel.mixinClass()), constraintClasses}));
                CompositeMethodModel methodComposite = new CompositeMethodModel(method, constraints, concernsModel, sideEffectsModel, this.mixinsModel);
                Iterable map = Iterables.map((Function)new DependencyModel.InjectionTypeFunction(), (Iterable)Iterables.filter((Specification)new DependencyModel.ScopeSpecification(This.class), methodComposite.dependencies()));
                Iterable map1 = Iterables.map((Function)new DependencyModel.InjectionTypeFunction(), (Iterable)Iterables.filter((Specification)new DependencyModel.ScopeSpecification(This.class), mixinModel.dependencies()));
                Iterable filter = Iterables.filter((Specification)Specifications.not((Specification)Specifications.in((Object[])new Class[]{Initializable.class, Lifecycle.class, InvocationHandler.class})), (Iterable)Iterables.map((Function)Classes.RAW_CLASS, (Iterable)Classes.interfacesOf(mixinModel.mixinClass())));
                Iterable flatten = Iterables.flatten((Iterable[])new Iterable[]{map, map1, filter});
                Iterables.addAll(thisDependencies, (Iterable)flatten);
                this.compositeMethodsModel.addMethod(methodComposite);
            }
            this.mixinsModel.addMixinType(mixinType);
        }
        for (Class<Object> thisDependency : thisDependencies) {
            Iterable typeConstraintClasses = Iterables.flatten((Iterable[])new Iterable[]{constraintClasses, this.constraintDeclarations(thisDependency)});
            Iterable typeConcernClasses = Iterables.flatten((Iterable[])new Iterable[]{concernClasses, this.concernDeclarations(thisDependency)});
            Iterable typeSideEffectClasses = Iterables.flatten((Iterable[])new Iterable[]{sideEffectClasses, this.sideEffectDeclarations(thisDependency)});
            Iterable typeMixinClasses = Iterables.flatten((Iterable[])new Iterable[]{mixinClasses, this.mixinDeclarations(thisDependency)});
            Iterable singleton = Iterables.iterable((Object[])new Class[]{thisDependency});
            this.implementMixinType(singleton, typeConstraintClasses, typeConcernClasses, typeSideEffectClasses, typeMixinClasses);
        }
    }

    protected MixinModel implementMethod(Method method, Iterable<Class<?>> mixinDeclarations) {
        MixinModel implementationModel = this.mixinsModel.mixinFor(method);
        if (implementationModel != null) {
            return implementationModel;
        }
        Class<?> mixinClass = this.findTypedImplementation(method, mixinDeclarations);
        if (mixinClass != null) {
            return this.implementMethodWithClass(method, mixinClass);
        }
        mixinClass = this.findGenericImplementation(method, mixinDeclarations);
        if (mixinClass != null) {
            return this.implementMethodWithClass(method, mixinClass);
        }
        throw new InvalidCompositeException("No implementation found for method \n    " + method.toGenericString() + "\nin\n    " + this.types);
    }

    private Class findTypedImplementation(final Method method, Iterable<Class<?>> mixins) {
        Specification appliesToSpec = new Specification<Class<?>>(){

            public boolean satisfiedBy(Class<?> item) {
                return CompositeAssemblyImpl.this.helper.appliesTo(item, method, CompositeAssemblyImpl.this.types, item);
            }
        };
        return (Class)Iterables.first((Iterable)Iterables.filter((Specification)Specifications.and((Specification[])new Specification[]{Classes.isAssignableFrom(method.getDeclaringClass()), Specifications.or((Specification[])new Specification[]{GenericSpecification.INSTANCE, appliesToSpec})}), mixins));
    }

    private Class<?> findGenericImplementation(final Method method, Iterable<Class<?>> mixins) {
        return (Class)Iterables.first((Iterable)Iterables.filter((Specification)Specifications.and((Specification[])new Specification[]{GenericSpecification.INSTANCE, new Specification<Class<?>>(){

            public boolean satisfiedBy(Class<?> item) {
                return CompositeAssemblyImpl.this.helper.appliesTo(item, method, CompositeAssemblyImpl.this.types, item);
            }
        }}), mixins));
    }

    private MixinModel implementMethodWithClass(Method method, Class mixinClass) {
        MixinModel mixinModel = this.mixinsModel.getMixinModel(mixinClass);
        if (mixinModel == null) {
            mixinModel = this.helper.getMixinModel(mixinClass);
            this.mixinsModel.addMixinModel(mixinModel);
        }
        this.mixinsModel.addMethodMixin(method, mixinModel);
        return mixinModel;
    }

    protected void addState(final Iterable<Class<? extends Constraint<?, ?>>> constraintClasses) {
        this.compositeMethodsModel.accept(new HierarchicalVisitorAdapter<Object, Object, RuntimeException>(){

            public boolean visitEnter(Object visited) throws RuntimeException {
                if (visited instanceof CompositeMethodModel) {
                    CompositeMethodModel methodModel = (CompositeMethodModel)visited;
                    if (methodModel.method().getParameterTypes().length == 0) {
                        CompositeAssemblyImpl.this.addStateFor(methodModel.method(), constraintClasses);
                    }
                    return false;
                }
                return super.visitEnter(visited);
            }
        });
        this.mixinsModel.accept(new HierarchicalVisitorAdapter<Object, Object, RuntimeException>(){

            public boolean visitEnter(Object visited) throws RuntimeException {
                if (visited instanceof MixinModel) {
                    MixinModel model = (MixinModel)visited;
                    Visitor<Field, RuntimeException> addState = new Visitor<Field, RuntimeException>(){

                        public boolean visit(Field visited) throws RuntimeException {
                            CompositeAssemblyImpl.this.addStateFor(visited, constraintClasses);
                            return true;
                        }
                    };
                    ForEach.forEach((Iterable)((Iterable)Fields.FIELDS_OF.map(model.mixinClass()))).filter(Annotations.hasAnnotation(State.class)).visit((Visitor)addState);
                    return false;
                }
                return super.visitEnter(visited);
            }
        });
    }

    protected void addStateFor(AccessibleObject accessor, Iterable<Class<? extends Constraint<?, ?>>> constraintClasses) {
        String stateName = QualifiedName.fromAccessor((AccessibleObject)accessor).name();
        if (this.registeredStateNames.contains(stateName)) {
            return;
        }
        if (Property.class.isAssignableFrom((Class)Classes.RAW_CLASS.map((Object)Classes.typeOf((AccessibleObject)accessor)))) {
            this.propertiesModel.addProperty(this.newPropertyModel(accessor, constraintClasses));
            this.registeredStateNames.add(stateName);
        }
    }

    protected PropertyModel newPropertyModel(AccessibleObject accessor, Iterable<Class<? extends Constraint<?, ?>>> constraintClasses) {
        Iterable annotations = Annotations.findAccessorAndTypeAnnotationsIn((AccessibleObject)accessor);
        boolean optional = Iterables.first((Iterable)Iterables.filter((Specification)Annotations.isType(Optional.class), (Iterable)annotations)) != null;
        ValueConstraintsModel valueConstraintsModel = this.constraintsFor(annotations, GenericPropertyInfo.propertyTypeOf((AccessibleObject)accessor), ((Member)((Object)accessor)).getName(), optional, constraintClasses, accessor);
        ValueConstraintsInstance valueConstraintsInstance = null;
        if (valueConstraintsModel.isConstrained()) {
            valueConstraintsInstance = valueConstraintsModel.newInstance();
        }
        MetaInfo metaInfo = this.stateDeclarations.metaInfoFor(accessor);
        Object initialValue = this.stateDeclarations.initialValueOf(accessor);
        boolean useDefaults = metaInfo.get(UseDefaults.class) != null || this.stateDeclarations.useDefaults(accessor);
        boolean immutable = this.immutable || metaInfo.get(Immutable.class) != null;
        PropertyModel propertyModel = new PropertyModel(accessor, immutable, useDefaults, valueConstraintsInstance, metaInfo, initialValue);
        return propertyModel;
    }

    private ConstraintsModel constraintsFor(Method method, Iterable<Class<? extends Constraint<?, ?>>> constraintClasses) {
        List<ValueConstraintsModel> parameterConstraintModels = Collections.emptyList();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Type[] parameterTypes = method.getGenericParameterTypes();
        boolean constrained = false;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Object[] parameterAnnotation = parameterAnnotations[i];
            Name nameAnnotation = (Name)Iterables.first((Iterable)Iterables.filter((Specification)Annotations.isType(Name.class), (Iterable)Iterables.iterable((Object[])parameterAnnotation)));
            String name = nameAnnotation == null ? "param" + (i + 1) : nameAnnotation.value();
            boolean optional = Iterables.first((Iterable)Iterables.filter((Specification)Annotations.isType(Optional.class), (Iterable)Iterables.iterable((Object[])parameterAnnotation))) != null;
            ValueConstraintsModel parameterConstraintsModel = this.constraintsFor(Arrays.asList(parameterAnnotation), parameterTypes[i], name, optional, constraintClasses, method);
            if (parameterConstraintsModel.isConstrained()) {
                constrained = true;
            }
            if (parameterConstraintModels.isEmpty()) {
                parameterConstraintModels = new ArrayList<ValueConstraintsModel>();
            }
            parameterConstraintModels.add(parameterConstraintsModel);
        }
        if (!constrained) {
            return new ConstraintsModel(Collections.emptyList());
        }
        return new ConstraintsModel(parameterConstraintModels);
    }

    protected ValueConstraintsModel constraintsFor(Iterable<Annotation> constraintAnnotations, Type valueType, String name, boolean optional, Iterable<Class<? extends Constraint<?, ?>>> constraintClasses, AccessibleObject accessor) {
        valueType = Classes.wrapperClass((Type)valueType);
        ArrayList<AbstractConstraintModel> constraintModels = new ArrayList<AbstractConstraintModel>();
        block0: for (Annotation constraintAnnotation : Iterables.filter((Specification)Specifications.translate((Function)Annotations.type(), (Specification)Annotations.hasAnnotation(ConstraintDeclaration.class)), constraintAnnotations)) {
            Class<? extends Annotation> annotationType = constraintAnnotation.annotationType();
            for (Class<Constraint<?, ?>> clazz : constraintClasses) {
                if (!this.helper.appliesTo(clazz, annotationType, valueType)) continue;
                constraintModels.add(new ConstraintModel(constraintAnnotation, clazz));
                continue block0;
            }
            Constraints constraints = annotationType.getAnnotation(Constraints.class);
            if (constraints != null) {
                for (Class constraintClass : constraints.value()) {
                    if (!this.helper.appliesTo(constraintClass, annotationType, valueType)) continue;
                    constraintModels.add(new ConstraintModel(constraintAnnotation, constraintClass));
                    continue block0;
                }
            }
            Iterable iterable = Iterables.iterable((Object[])annotationType.getAnnotations());
            if (Iterables.matchesAny((Specification)Specifications.translate((Function)Annotations.type(), (Specification)Annotations.hasAnnotation(ConstraintDeclaration.class)), (Iterable)iterable)) {
                ValueConstraintsModel valueConstraintsModel = this.constraintsFor(iterable, valueType, name, optional, constraintClasses, accessor);
                CompositeConstraintModel compositeConstraintModel = new CompositeConstraintModel(constraintAnnotation, valueConstraintsModel);
                constraintModels.add(compositeConstraintModel);
                continue;
            }
            throw new InvalidCompositeException("Cannot find implementation of constraint @" + annotationType.getSimpleName() + " for " + valueType + " in method " + ((Member)((Object)accessor)).getName() + " of composite " + this.types);
        }
        return new ValueConstraintsModel(constraintModels, name, optional);
    }

    private ConcernsModel concernsFor(Method method, Class<?> mixinClass, Iterable<Class<?>> concernClasses) {
        ArrayList<ConcernModel> concernsFor = new ArrayList<ConcernModel>();
        for (Class<?> concern : concernClasses) {
            if (this.helper.appliesTo(concern, method, this.types, mixinClass)) {
                concernsFor.add(this.helper.getConcernModel(concern));
                continue;
            }
            if (InvocationHandler.class.isAssignableFrom(mixinClass)) continue;
            try {
                Method mixinMethod = mixinClass.getMethod(method.getName(), method.getParameterTypes());
                if (!this.helper.appliesTo(concern, mixinMethod, this.types, mixinClass)) continue;
                concernsFor.add(this.helper.getConcernModel(concern));
            }
            catch (NoSuchMethodException e) {}
        }
        for (Annotation annotation : method.getAnnotations()) {
            Concerns concerns = annotation.annotationType().getAnnotation(Concerns.class);
            if (concerns == null) continue;
            for (Class concern : concerns.value()) {
                if (!this.helper.appliesTo(concern, method, this.types, mixinClass)) continue;
                concernsFor.add(this.helper.getConcernModel(concern));
            }
        }
        if (concernsFor.isEmpty()) {
            return ConcernsModel.EMPTY_CONCERNS;
        }
        return new ConcernsModel(concernsFor);
    }

    private SideEffectsModel sideEffectsFor(Method method, Class<?> mixinClass, Iterable<Class<?>> sideEffectClasses) {
        ArrayList<SideEffectModel> sideEffectsFor = new ArrayList<SideEffectModel>();
        for (Class<?> sideEffect : sideEffectClasses) {
            if (this.helper.appliesTo(sideEffect, method, this.types, mixinClass)) {
                sideEffectsFor.add(this.helper.getSideEffectModel(sideEffect));
                continue;
            }
            if (InvocationHandler.class.isAssignableFrom(mixinClass)) continue;
            try {
                Method mixinMethod = mixinClass.getMethod(method.getName(), method.getParameterTypes());
                if (!this.helper.appliesTo(sideEffect, mixinMethod, this.types, mixinClass)) continue;
                sideEffectsFor.add(this.helper.getSideEffectModel(sideEffect));
            }
            catch (NoSuchMethodException e) {}
        }
        if (sideEffectsFor.isEmpty()) {
            return SideEffectsModel.EMPTY_SIDEEFFECTS;
        }
        return new SideEffectsModel(sideEffectsFor);
    }

    private Iterable<Class<? extends Constraint<?, ?>>> constraintDeclarations(Class<?> type) {
        ArrayList<Type> allTypes = this.getTypes(type);
        return this.constraintDeclarations(allTypes);
    }

    private Iterable<Class<? extends Constraint<?, ?>>> constraintDeclarations(ArrayList<Type> allTypes) {
        Function function = new Function<Type, Iterable<Class<? extends Constraint<?, ?>>>>(){

            public Iterable<Class<? extends Constraint<?, ?>>> map(Type type) {
                Constraints constraints = (Constraints)Annotations.annotationOn((Type)type, Constraints.class);
                if (constraints == null) {
                    return Iterables.empty();
                }
                return Iterables.iterable((Object[])constraints.value());
            }
        };
        Iterable flatten = Iterables.flattenIterables((Iterable)Iterables.map((Function)function, allTypes));
        return Iterables.toList((Iterable)flatten);
    }

    private Iterable<Class<?>> concernDeclarations(Class<?> type) {
        Iterable iterable = Iterables.iterable((Object[])new Class[]{type});
        return this.concernDeclarations(this.getTypes(iterable));
    }

    private Iterable<Class<?>> concernDeclarations(ArrayList<Type> allTypes) {
        Function function = new Function<Type, Iterable<Class<?>>>(){

            public Iterable<Class<?>> map(Type type) {
                Concerns concerns = (Concerns)Annotations.annotationOn((Type)type, Concerns.class);
                if (concerns == null) {
                    return Iterables.empty();
                }
                return Iterables.iterable((Object[])concerns.value());
            }
        };
        Iterable flatten = Iterables.flattenIterables((Iterable)Iterables.map((Function)function, allTypes));
        return Iterables.toList((Iterable)flatten);
    }

    protected Iterable<Class<?>> sideEffectDeclarations(Class<?> type) {
        Iterable iterable = Iterables.iterable((Object[])new Class[]{type});
        return this.sideEffectDeclarations(this.getTypes(iterable));
    }

    protected Iterable<Class<?>> sideEffectDeclarations(ArrayList<Type> allTypes) {
        Function function = new Function<Type, Iterable<Class<?>>>(){

            public Iterable<Class<?>> map(Type type) {
                SideEffects sideEffects = (SideEffects)Annotations.annotationOn((Type)type, SideEffects.class);
                if (sideEffects == null) {
                    return Iterables.empty();
                }
                return Iterables.iterable((Object[])sideEffects.value());
            }
        };
        Iterable flatten = Iterables.flattenIterables((Iterable)Iterables.map((Function)function, allTypes));
        return Iterables.toList((Iterable)flatten);
    }

    private ArrayList<Type> getTypes(Class<?> type) {
        Iterable iterable = Iterables.iterable((Object[])new Class[]{type});
        return this.getTypes(iterable);
    }

    private ArrayList<Type> getTypes(Iterable<? extends Class<?>> typess) {
        ArrayList<Type> allTypes = new ArrayList<Type>();
        for (Class<?> type : typess) {
            Iterable types = type.isInterface() ? Classes.typesOf(type) : Iterables.cast((Iterable)Classes.classHierarchy(type));
            Iterables.addAll(allTypes, (Iterable)types);
        }
        return allTypes;
    }

    protected Iterable<Class<?>> mixinDeclarations(Class<?> type) {
        Iterable iterable = Iterables.iterable((Object[])new Class[]{type});
        return this.mixinDeclarations(iterable);
    }

    protected Iterable<Class<?>> mixinDeclarations(Iterable<? extends Class<?>> typess) {
        ArrayList allTypes = new ArrayList();
        for (Class<?> type : typess) {
            Iterable types = Classes.typesOf(type);
            Iterables.addAll(allTypes, (Iterable)types);
        }
        Function function = new Function<Type, Iterable<Class<?>>>(){

            public Iterable<Class<?>> map(Type type) {
                Mixins mixins = (Mixins)Annotations.annotationOn((Type)type, Mixins.class);
                if (mixins == null) {
                    return Iterables.empty();
                }
                return Iterables.iterable((Object[])mixins.value());
            }
        };
        Iterable flatten = Iterables.flattenIterables((Iterable)Iterables.map((Function)function, allTypes));
        return Iterables.toList((Iterable)flatten);
    }
}

