/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.util.Arrays;
import org.qi4j.api.common.Visibility;
import org.qi4j.bootstrap.ConfigurationDeclaration;
import org.qi4j.runtime.bootstrap.EntityAssemblyImpl;
import org.qi4j.runtime.bootstrap.ValueAssemblyImpl;

public final class ConfigurationDeclarationImpl
implements ConfigurationDeclaration {
    private final Iterable<EntityAssemblyImpl> entities;
    private final Iterable<ValueAssemblyImpl> values;

    public ConfigurationDeclarationImpl(Iterable<EntityAssemblyImpl> entities, Iterable<ValueAssemblyImpl> values) {
        this.entities = entities;
        this.values = values;
    }

    public ConfigurationDeclaration setMetaInfo(Object info) {
        for (EntityAssemblyImpl entity : this.entities) {
            entity.metaInfo.set(info);
        }
        for (ValueAssemblyImpl value : this.values) {
            value.metaInfo.set(info);
        }
        return this;
    }

    public ConfigurationDeclaration visibleIn(Visibility visibility) {
        for (EntityAssemblyImpl entity : this.entities) {
            entity.visibility = visibility;
        }
        for (ValueAssemblyImpl value : this.values) {
            value.visibility = visibility;
        }
        return this;
    }

    public ConfigurationDeclaration withConcerns(Class<?> ... concerns) {
        for (EntityAssemblyImpl entity : this.entities) {
            entity.concerns.addAll(Arrays.asList(concerns));
        }
        for (ValueAssemblyImpl value : this.values) {
            value.concerns.addAll(Arrays.asList(concerns));
        }
        return this;
    }

    public ConfigurationDeclaration withSideEffects(Class<?> ... sideEffects) {
        for (EntityAssemblyImpl entity : this.entities) {
            entity.sideEffects.addAll(Arrays.asList(sideEffects));
        }
        for (ValueAssemblyImpl value : this.values) {
            value.sideEffects.addAll(Arrays.asList(sideEffects));
        }
        return this;
    }

    public ConfigurationDeclaration withMixins(Class<?> ... mixins) {
        for (EntityAssemblyImpl entity : this.entities) {
            entity.mixins.addAll(Arrays.asList(mixins));
        }
        for (ValueAssemblyImpl value : this.values) {
            value.mixins.addAll(Arrays.asList(mixins));
        }
        return this;
    }

    public ConfigurationDeclaration withTypes(Class<?> ... types) {
        for (EntityAssemblyImpl entity : this.entities) {
            entity.types.addAll(Arrays.asList(types));
        }
        for (ValueAssemblyImpl value : this.values) {
            value.types.addAll(Arrays.asList(types));
        }
        return this;
    }
}

