/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.GenericAssociationInfo;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.common.InvalidApplicationException;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.common.UseDefaults;
import org.qi4j.api.constraint.Constraint;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.property.GenericPropertyInfo;
import org.qi4j.api.property.Immutable;
import org.qi4j.api.property.Property;
import org.qi4j.api.util.Annotations;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.AssociationDeclarations;
import org.qi4j.bootstrap.EntityAssembly;
import org.qi4j.bootstrap.ManyAssociationDeclarations;
import org.qi4j.bootstrap.NamedAssociationDeclarations;
import org.qi4j.bootstrap.StateDeclarations;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.runtime.association.AssociationModel;
import org.qi4j.runtime.association.AssociationsModel;
import org.qi4j.runtime.association.ManyAssociationModel;
import org.qi4j.runtime.association.ManyAssociationsModel;
import org.qi4j.runtime.association.NamedAssociationModel;
import org.qi4j.runtime.association.NamedAssociationsModel;
import org.qi4j.runtime.bootstrap.AssemblyHelper;
import org.qi4j.runtime.bootstrap.CompositeAssemblyImpl;
import org.qi4j.runtime.composite.MixinsModel;
import org.qi4j.runtime.composite.StateModel;
import org.qi4j.runtime.composite.ValueConstraintsInstance;
import org.qi4j.runtime.composite.ValueConstraintsModel;
import org.qi4j.runtime.entity.EntityMixinsModel;
import org.qi4j.runtime.entity.EntityModel;
import org.qi4j.runtime.entity.EntityStateModel;
import org.qi4j.runtime.property.PropertyModel;

public final class EntityAssemblyImpl
extends CompositeAssemblyImpl
implements EntityAssembly {
    private AssociationDeclarations associationDeclarations;
    private ManyAssociationDeclarations manyAssociationDeclarations;
    private NamedAssociationDeclarations namedAssociationDeclarations;
    private AssociationsModel associationsModel;
    private ManyAssociationsModel manyAssociationsModel;
    private NamedAssociationsModel namedAssociationsModel;

    public EntityAssemblyImpl(Class<?> entityType) {
        super(entityType);
        if (!EntityComposite.class.isAssignableFrom(entityType)) {
            this.types.add(EntityComposite.class);
        }
    }

    @Override
    protected MixinsModel createMixinsModel() {
        return new EntityMixinsModel();
    }

    @Override
    protected StateModel createStateModel() {
        return new EntityStateModel(this.propertiesModel, this.associationsModel, this.manyAssociationsModel, this.namedAssociationsModel);
    }

    EntityModel newEntityModel(StateDeclarations stateDeclarations, AssociationDeclarations associationDecs, ManyAssociationDeclarations manyAssociationDecs, NamedAssociationDeclarations namedAssociationDecs, AssemblyHelper helper) {
        this.associationDeclarations = associationDecs;
        this.manyAssociationDeclarations = manyAssociationDecs;
        this.namedAssociationDeclarations = namedAssociationDecs;
        try {
            this.associationsModel = new AssociationsModel();
            this.manyAssociationsModel = new ManyAssociationsModel();
            this.namedAssociationsModel = new NamedAssociationsModel();
            this.buildComposite(helper, stateDeclarations);
            EntityModel entityModel = new EntityModel(this.types, this.visibility, this.metaInfo, (EntityMixinsModel)this.mixinsModel, (EntityStateModel)this.stateModel, this.compositeMethodsModel);
            return entityModel;
        }
        catch (Exception e) {
            throw new InvalidApplicationException("Could not register " + this.types, (Throwable)e);
        }
    }

    @Override
    protected void addStateFor(AccessibleObject accessor, Iterable<Class<? extends Constraint<?, ?>>> constraintClasses) {
        String stateName = QualifiedName.fromAccessor((AccessibleObject)accessor).name();
        if (this.registeredStateNames.contains(stateName)) {
            return;
        }
        Class accessorType = (Class)Classes.RAW_CLASS.map((Object)Classes.typeOf((AccessibleObject)accessor));
        if (Property.class.isAssignableFrom(accessorType)) {
            this.propertiesModel.addProperty(this.newPropertyModel(accessor, constraintClasses));
            this.registeredStateNames.add(stateName);
        } else if (Association.class.isAssignableFrom(accessorType)) {
            this.associationsModel.addAssociation(this.newAssociationModel(accessor, constraintClasses));
            this.registeredStateNames.add(stateName);
        } else if (ManyAssociation.class.isAssignableFrom(accessorType)) {
            this.manyAssociationsModel.addManyAssociation(this.newManyAssociationModel(accessor, constraintClasses));
            this.registeredStateNames.add(stateName);
        } else if (NamedAssociation.class.isAssignableFrom(accessorType)) {
            this.namedAssociationsModel.addNamedAssociation(this.newNamedAssociationModel(accessor, constraintClasses));
            this.registeredStateNames.add(stateName);
        }
    }

    @Override
    protected PropertyModel newPropertyModel(AccessibleObject accessor, Iterable<Class<? extends Constraint<?, ?>>> constraintClasses) {
        Iterable annotations = Annotations.findAccessorAndTypeAnnotationsIn((AccessibleObject)accessor);
        boolean optional = Iterables.first((Iterable)Iterables.filter((Specification)Annotations.isType(Optional.class), (Iterable)annotations)) != null;
        ValueConstraintsModel valueConstraintsModel = this.constraintsFor(annotations, GenericPropertyInfo.propertyTypeOf((AccessibleObject)accessor), ((Member)((Object)accessor)).getName(), optional, constraintClasses, accessor);
        ValueConstraintsInstance valueConstraintsInstance = null;
        if (valueConstraintsModel.isConstrained()) {
            valueConstraintsInstance = valueConstraintsModel.newInstance();
        }
        MetaInfo metaInfo = this.stateDeclarations.metaInfoFor(accessor);
        Object defaultValue = this.stateDeclarations.initialValueOf(accessor);
        boolean useDefaults = metaInfo.get(UseDefaults.class) != null || this.stateDeclarations.useDefaults(accessor);
        boolean immutable = this.immutable || metaInfo.get(Immutable.class) != null;
        PropertyModel propertyModel = new PropertyModel(accessor, immutable, useDefaults, valueConstraintsInstance, metaInfo, defaultValue);
        return propertyModel;
    }

    public AssociationModel newAssociationModel(AccessibleObject accessor, Iterable<Class<? extends Constraint<?, ?>>> constraintClasses) {
        Iterable annotations = Annotations.findAccessorAndTypeAnnotationsIn((AccessibleObject)accessor);
        boolean optional = Iterables.first((Iterable)Iterables.filter((Specification)Annotations.isType(Optional.class), (Iterable)annotations)) != null;
        ValueConstraintsModel valueConstraintsModel = this.constraintsFor(annotations, GenericAssociationInfo.associationTypeOf((AccessibleObject)accessor), ((Member)((Object)accessor)).getName(), optional, constraintClasses, accessor);
        ValueConstraintsInstance valueConstraintsInstance = null;
        if (valueConstraintsModel.isConstrained()) {
            valueConstraintsInstance = valueConstraintsModel.newInstance();
        }
        valueConstraintsModel = this.constraintsFor(annotations, (Type)((Object)Association.class), ((Member)((Object)accessor)).getName(), optional, constraintClasses, accessor);
        ValueConstraintsInstance associationValueConstraintsInstance = null;
        if (valueConstraintsModel.isConstrained()) {
            associationValueConstraintsInstance = valueConstraintsModel.newInstance();
        }
        MetaInfo metaInfo = this.associationDeclarations.metaInfoFor(accessor);
        AssociationModel associationModel = new AssociationModel(accessor, valueConstraintsInstance, associationValueConstraintsInstance, metaInfo);
        return associationModel;
    }

    public ManyAssociationModel newManyAssociationModel(AccessibleObject accessor, Iterable<Class<? extends Constraint<?, ?>>> constraintClasses) {
        Iterable annotations = Annotations.findAccessorAndTypeAnnotationsIn((AccessibleObject)accessor);
        boolean optional = Iterables.first((Iterable)Iterables.filter((Specification)Annotations.isType(Optional.class), (Iterable)annotations)) != null;
        ValueConstraintsModel valueConstraintsModel = this.constraintsFor(annotations, GenericAssociationInfo.associationTypeOf((AccessibleObject)accessor), ((Member)((Object)accessor)).getName(), optional, constraintClasses, accessor);
        ValueConstraintsInstance valueConstraintsInstance = null;
        if (valueConstraintsModel.isConstrained()) {
            valueConstraintsInstance = valueConstraintsModel.newInstance();
        }
        valueConstraintsModel = this.constraintsFor(annotations, (Type)((Object)ManyAssociation.class), ((Member)((Object)accessor)).getName(), optional, constraintClasses, accessor);
        ValueConstraintsInstance manyValueConstraintsInstance = null;
        if (valueConstraintsModel.isConstrained()) {
            manyValueConstraintsInstance = valueConstraintsModel.newInstance();
        }
        MetaInfo metaInfo = this.manyAssociationDeclarations.metaInfoFor(accessor);
        ManyAssociationModel associationModel = new ManyAssociationModel(accessor, valueConstraintsInstance, manyValueConstraintsInstance, metaInfo);
        return associationModel;
    }

    public NamedAssociationModel newNamedAssociationModel(AccessibleObject accessor, Iterable<Class<? extends Constraint<?, ?>>> constraintClasses) {
        Iterable annotations = Annotations.findAccessorAndTypeAnnotationsIn((AccessibleObject)accessor);
        boolean optional = Iterables.first((Iterable)Iterables.filter((Specification)Annotations.isType(Optional.class), (Iterable)annotations)) != null;
        ValueConstraintsModel valueConstraintsModel = this.constraintsFor(annotations, GenericAssociationInfo.associationTypeOf((AccessibleObject)accessor), ((Member)((Object)accessor)).getName(), optional, constraintClasses, accessor);
        ValueConstraintsInstance valueConstraintsInstance = null;
        if (valueConstraintsModel.isConstrained()) {
            valueConstraintsInstance = valueConstraintsModel.newInstance();
        }
        valueConstraintsModel = this.constraintsFor(annotations, (Type)((Object)NamedAssociation.class), ((Member)((Object)accessor)).getName(), optional, constraintClasses, accessor);
        ValueConstraintsInstance namedValueConstraintsInstance = null;
        if (valueConstraintsModel.isConstrained()) {
            namedValueConstraintsInstance = valueConstraintsModel.newInstance();
        }
        MetaInfo metaInfo = this.namedAssociationDeclarations.metaInfoFor(accessor);
        NamedAssociationModel associationModel = new NamedAssociationModel(accessor, valueConstraintsInstance, namedValueConstraintsInstance, metaInfo);
        return associationModel;
    }
}

