/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.qi4j.api.activation.Activator;
import org.qi4j.api.common.InvalidApplicationException;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.api.service.importer.InstanceImporter;
import org.qi4j.bootstrap.ImportedServiceAssembly;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.activation.ActivatorsModel;
import org.qi4j.runtime.bootstrap.ModuleAssemblyImpl;
import org.qi4j.runtime.service.ImportedServiceModel;

public final class ImportedServiceAssemblyImpl
implements ImportedServiceAssembly {
    private final Class<?> serviceType;
    private final ModuleAssemblyImpl moduleAssembly;
    Class<? extends ServiceImporter> serviceProvider = InstanceImporter.class;
    String identity;
    boolean importOnStartup = false;
    MetaInfo metaInfo = new MetaInfo();
    Visibility visibility = Visibility.module;
    List<Class<? extends Activator<?>>> activators = new ArrayList();

    public ImportedServiceAssemblyImpl(Class<?> serviceType, ModuleAssemblyImpl moduleAssembly) {
        this.serviceType = serviceType;
        this.moduleAssembly = moduleAssembly;
    }

    public Iterable<Class<?>> types() {
        return Iterables.iterable((Object[])new Class[]{this.serviceType});
    }

    void addImportedServiceModel(List<ImportedServiceModel> serviceModels) {
        try {
            String id = this.identity;
            if (id == null) {
                id = this.generateId(serviceModels, this.serviceType);
            }
            ImportedServiceModel serviceModel = new ImportedServiceModel(this.serviceType, this.visibility, this.serviceProvider, id, this.importOnStartup, new MetaInfo(this.metaInfo).withAnnotations(this.serviceType), new ActivatorsModel(this.activators), this.moduleAssembly.name());
            serviceModels.add(serviceModel);
        }
        catch (Exception e) {
            throw new InvalidApplicationException("Could not register " + this.serviceType.getName(), (Throwable)e);
        }
    }

    private String generateId(List<ImportedServiceModel> serviceModels, Class serviceType) {
        boolean invalid;
        int idx = 0;
        String id = serviceType.getSimpleName();
        block0: do {
            invalid = false;
            for (ImportedServiceModel serviceModel : serviceModels) {
                if (!serviceModel.identity().equals(id)) continue;
                id = serviceType.getSimpleName() + "_" + ++idx;
                invalid = true;
                continue block0;
            }
        } while (invalid);
        return id;
    }
}

