/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.qi4j.api.activation.Activator;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.api.service.qualifier.ServiceTags;
import org.qi4j.bootstrap.ImportedServiceDeclaration;
import org.qi4j.runtime.bootstrap.ImportedServiceAssemblyImpl;

public final class ImportedServiceDeclarationImpl
implements ImportedServiceDeclaration {
    private final Iterable<ImportedServiceAssemblyImpl> assemblies;

    public ImportedServiceDeclarationImpl(Iterable<ImportedServiceAssemblyImpl> assemblies) {
        this.assemblies = assemblies;
    }

    public ImportedServiceDeclaration importOnStartup() {
        for (ImportedServiceAssemblyImpl assembly : this.assemblies) {
            assembly.importOnStartup = true;
        }
        return this;
    }

    public ImportedServiceDeclaration visibleIn(Visibility visibility) {
        for (ImportedServiceAssemblyImpl assembly : this.assemblies) {
            assembly.visibility = visibility;
        }
        return this;
    }

    public ImportedServiceDeclaration importedBy(Class<? extends ServiceImporter> sip) {
        for (ImportedServiceAssemblyImpl assembly : this.assemblies) {
            assembly.serviceProvider = sip;
        }
        return this;
    }

    public ImportedServiceDeclaration identifiedBy(String identity) {
        for (ImportedServiceAssemblyImpl assembly : this.assemblies) {
            assembly.identity = identity;
        }
        return this;
    }

    public ImportedServiceDeclaration taggedWith(String ... tags) {
        for (ImportedServiceAssemblyImpl serviceAssembly : this.assemblies) {
            ServiceTags previousTags = (ServiceTags)serviceAssembly.metaInfo.get(ServiceTags.class);
            if (previousTags != null) {
                ArrayList tagList = new ArrayList();
                Collections.addAll(tagList, previousTags.tags());
                Collections.addAll(tagList, tags);
                serviceAssembly.metaInfo.set((Object)new ServiceTags(tagList.toArray(new String[tagList.size()])));
                continue;
            }
            serviceAssembly.metaInfo.set((Object)new ServiceTags(tags));
        }
        return this;
    }

    public ImportedServiceDeclaration setMetaInfo(Object serviceAttribute) {
        for (ImportedServiceAssemblyImpl assembly : this.assemblies) {
            assembly.metaInfo.set(serviceAttribute);
        }
        return this;
    }

    @SafeVarargs
    public final ImportedServiceDeclaration withActivators(Class<? extends Activator<?>> ... activators) {
        for (ImportedServiceAssemblyImpl serviceAssembly : this.assemblies) {
            serviceAssembly.activators.addAll(Arrays.asList(activators));
        }
        return this;
    }
}

