/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.qi4j.api.activation.Activator;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.api.structure.Layer;
import org.qi4j.bootstrap.ApplicationAssembly;
import org.qi4j.bootstrap.AssemblyVisitor;
import org.qi4j.bootstrap.EntityAssembly;
import org.qi4j.bootstrap.EntityDeclaration;
import org.qi4j.bootstrap.ImportedServiceAssembly;
import org.qi4j.bootstrap.ImportedServiceDeclaration;
import org.qi4j.bootstrap.LayerAssembly;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.bootstrap.ObjectAssembly;
import org.qi4j.bootstrap.ObjectDeclaration;
import org.qi4j.bootstrap.ServiceAssembly;
import org.qi4j.bootstrap.ServiceDeclaration;
import org.qi4j.bootstrap.TransientAssembly;
import org.qi4j.bootstrap.TransientDeclaration;
import org.qi4j.bootstrap.ValueAssembly;
import org.qi4j.bootstrap.ValueDeclaration;
import org.qi4j.functional.Specification;
import org.qi4j.runtime.bootstrap.ModuleAssemblyImpl;

public final class LayerAssemblyImpl
implements LayerAssembly {
    private final ApplicationAssembly applicationAssembly;
    private final HashMap<String, ModuleAssemblyImpl> moduleAssemblies;
    private final Set<LayerAssembly> uses;
    private String name;
    private final MetaInfo metaInfo = new MetaInfo();
    private final List<Class<? extends Activator<Layer>>> activators = new ArrayList<Class<? extends Activator<Layer>>>();

    public LayerAssemblyImpl(ApplicationAssembly applicationAssembly, String name) {
        this.applicationAssembly = applicationAssembly;
        this.name = name;
        this.moduleAssemblies = new LinkedHashMap<String, ModuleAssemblyImpl>();
        this.uses = new LinkedHashSet<LayerAssembly>();
    }

    public ModuleAssembly module(String name) {
        ModuleAssemblyImpl existing;
        if (name != null && (existing = this.moduleAssemblies.get(name)) != null) {
            return existing;
        }
        ModuleAssemblyImpl moduleAssembly = new ModuleAssemblyImpl(this, name);
        this.moduleAssemblies.put(name, moduleAssembly);
        return moduleAssembly;
    }

    public ApplicationAssembly application() {
        return this.applicationAssembly;
    }

    public LayerAssembly setName(String name) {
        this.name = name;
        return this;
    }

    public LayerAssembly setMetaInfo(Object info) {
        this.metaInfo.set(info);
        return this;
    }

    public LayerAssembly uses(LayerAssembly ... layerAssembly) throws IllegalArgumentException {
        this.uses.addAll(Arrays.asList(layerAssembly));
        return this;
    }

    @SafeVarargs
    public final LayerAssembly withActivators(Class<? extends Activator<Layer>> ... activators) {
        this.activators.addAll(Arrays.asList(activators));
        return this;
    }

    public <ThrowableType extends Throwable> void visit(AssemblyVisitor<ThrowableType> visitor) throws ThrowableType {
        visitor.visitLayer((LayerAssembly)this);
        for (ModuleAssemblyImpl moduleAssembly : this.moduleAssemblies.values()) {
            moduleAssembly.visit(visitor);
        }
    }

    public EntityDeclaration entities(Specification<? super EntityAssembly> specification) {
        final ArrayList<EntityDeclaration> declarations = new ArrayList<EntityDeclaration>();
        for (ModuleAssemblyImpl moduleAssembly : this.moduleAssemblies.values()) {
            declarations.add(moduleAssembly.entities(specification));
        }
        return new EntityDeclaration(){

            public EntityDeclaration setMetaInfo(Object info) {
                for (EntityDeclaration declaration : declarations) {
                    declaration.setMetaInfo(info);
                }
                return this;
            }

            public EntityDeclaration visibleIn(Visibility visibility) {
                for (EntityDeclaration declaration : declarations) {
                    declaration.visibleIn(visibility);
                }
                return this;
            }

            public EntityDeclaration withConcerns(Class<?> ... concerns) {
                for (EntityDeclaration declaration : declarations) {
                    declaration.withConcerns((Class[])concerns);
                }
                return this;
            }

            public EntityDeclaration withSideEffects(Class<?> ... sideEffects) {
                for (EntityDeclaration declaration : declarations) {
                    declaration.withSideEffects((Class[])sideEffects);
                }
                return this;
            }

            public EntityDeclaration withMixins(Class<?> ... mixins) {
                for (EntityDeclaration declaration : declarations) {
                    declaration.withMixins((Class[])mixins);
                }
                return this;
            }

            public EntityDeclaration withTypes(Class<?> ... types) {
                for (EntityDeclaration declaration : declarations) {
                    declaration.withTypes((Class[])types);
                }
                return this;
            }
        };
    }

    public ServiceDeclaration services(Specification<? super ServiceAssembly> specification) {
        final ArrayList<ServiceDeclaration> declarations = new ArrayList<ServiceDeclaration>();
        for (ModuleAssemblyImpl moduleAssembly : this.moduleAssemblies.values()) {
            declarations.add(moduleAssembly.services(specification));
        }
        return new ServiceDeclaration(){

            public ServiceDeclaration setMetaInfo(Object serviceAttribute) {
                for (ServiceDeclaration declaration : declarations) {
                    declaration.setMetaInfo(serviceAttribute);
                }
                return this;
            }

            public ServiceDeclaration visibleIn(Visibility visibility) {
                for (ServiceDeclaration declaration : declarations) {
                    declaration.visibleIn(visibility);
                }
                return this;
            }

            public ServiceDeclaration withConcerns(Class<?> ... concerns) {
                for (ServiceDeclaration declaration : declarations) {
                    declaration.withConcerns((Class[])concerns);
                }
                return this;
            }

            public ServiceDeclaration withSideEffects(Class<?> ... sideEffects) {
                for (ServiceDeclaration declaration : declarations) {
                    declaration.withSideEffects((Class[])sideEffects);
                }
                return this;
            }

            public ServiceDeclaration withMixins(Class<?> ... mixins) {
                for (ServiceDeclaration declaration : declarations) {
                    declaration.withMixins((Class[])mixins);
                }
                return this;
            }

            public ServiceDeclaration withTypes(Class<?> ... types) {
                for (ServiceDeclaration declaration : declarations) {
                    declaration.withTypes((Class[])types);
                }
                return this;
            }

            @SafeVarargs
            public final ServiceDeclaration withActivators(Class<? extends Activator<?>> ... activators) {
                for (ServiceDeclaration declaration : declarations) {
                    declaration.withActivators((Class[])activators);
                }
                return this;
            }

            public ServiceDeclaration identifiedBy(String identity) {
                for (ServiceDeclaration declaration : declarations) {
                    declaration.identifiedBy(identity);
                }
                return this;
            }

            public ServiceDeclaration taggedWith(String ... tags) {
                for (ServiceDeclaration declaration : declarations) {
                    declaration.taggedWith(tags);
                }
                return this;
            }

            public ServiceDeclaration instantiateOnStartup() {
                for (ServiceDeclaration declaration : declarations) {
                    declaration.instantiateOnStartup();
                }
                return this;
            }
        };
    }

    public TransientDeclaration transients(Specification<? super TransientAssembly> specification) {
        final ArrayList<TransientDeclaration> declarations = new ArrayList<TransientDeclaration>();
        for (ModuleAssemblyImpl moduleAssembly : this.moduleAssemblies.values()) {
            declarations.add(moduleAssembly.transients(specification));
        }
        return new TransientDeclaration(){

            public TransientDeclaration setMetaInfo(Object info) {
                for (TransientDeclaration declaration : declarations) {
                    declaration.setMetaInfo(info);
                }
                return this;
            }

            public TransientDeclaration visibleIn(Visibility visibility) {
                for (TransientDeclaration declaration : declarations) {
                    declaration.visibleIn(visibility);
                }
                return this;
            }

            public TransientDeclaration withConcerns(Class<?> ... concerns) {
                for (TransientDeclaration declaration : declarations) {
                    declaration.withConcerns((Class[])concerns);
                }
                return this;
            }

            public TransientDeclaration withSideEffects(Class<?> ... sideEffects) {
                for (TransientDeclaration declaration : declarations) {
                    declaration.withSideEffects((Class[])sideEffects);
                }
                return this;
            }

            public TransientDeclaration withMixins(Class<?> ... mixins) {
                for (TransientDeclaration declaration : declarations) {
                    declaration.withMixins((Class[])mixins);
                }
                return this;
            }

            public TransientDeclaration withTypes(Class<?> ... types) {
                for (TransientDeclaration declaration : declarations) {
                    declaration.withTypes((Class[])types);
                }
                return this;
            }
        };
    }

    public ValueDeclaration values(Specification<? super ValueAssembly> specification) {
        final ArrayList<ValueDeclaration> declarations = new ArrayList<ValueDeclaration>();
        for (ModuleAssemblyImpl moduleAssembly : this.moduleAssemblies.values()) {
            declarations.add(moduleAssembly.values(specification));
        }
        return new ValueDeclaration(){

            public ValueDeclaration setMetaInfo(Object info) {
                for (ValueDeclaration declaration : declarations) {
                    declaration.setMetaInfo(info);
                }
                return this;
            }

            public ValueDeclaration visibleIn(Visibility visibility) {
                for (ValueDeclaration declaration : declarations) {
                    declaration.visibleIn(visibility);
                }
                return this;
            }

            public ValueDeclaration withConcerns(Class<?> ... concerns) {
                for (ValueDeclaration declaration : declarations) {
                    declaration.withConcerns((Class[])concerns);
                }
                return this;
            }

            public ValueDeclaration withSideEffects(Class<?> ... sideEffects) {
                for (ValueDeclaration declaration : declarations) {
                    declaration.withSideEffects((Class[])sideEffects);
                }
                return this;
            }

            public ValueDeclaration withMixins(Class<?> ... mixins) {
                for (ValueDeclaration declaration : declarations) {
                    declaration.withMixins((Class[])mixins);
                }
                return this;
            }

            public ValueDeclaration withTypes(Class<?> ... types) {
                for (ValueDeclaration declaration : declarations) {
                    declaration.withTypes((Class[])types);
                }
                return this;
            }
        };
    }

    public ObjectDeclaration objects(Specification<? super ObjectAssembly> specification) {
        final ArrayList<ObjectDeclaration> declarations = new ArrayList<ObjectDeclaration>();
        for (ModuleAssemblyImpl moduleAssembly : this.moduleAssemblies.values()) {
            declarations.add(moduleAssembly.objects(specification));
        }
        return new ObjectDeclaration(){

            public ObjectDeclaration setMetaInfo(Object info) {
                for (ObjectDeclaration declaration : declarations) {
                    declaration.setMetaInfo(info);
                }
                return this;
            }

            public ObjectDeclaration visibleIn(Visibility visibility) throws IllegalStateException {
                for (ObjectDeclaration declaration : declarations) {
                    declaration.visibleIn(visibility);
                }
                return this;
            }
        };
    }

    public ImportedServiceDeclaration importedServices(Specification<? super ImportedServiceAssembly> specification) {
        final ArrayList<ImportedServiceDeclaration> declarations = new ArrayList<ImportedServiceDeclaration>();
        for (ModuleAssemblyImpl moduleAssembly : this.moduleAssemblies.values()) {
            declarations.add(moduleAssembly.importedServices(specification));
        }
        return new ImportedServiceDeclaration(){

            public ImportedServiceDeclaration importOnStartup() {
                for (ImportedServiceDeclaration declaration : declarations) {
                    declaration.importOnStartup();
                }
                return this;
            }

            public ImportedServiceDeclaration visibleIn(Visibility visibility) {
                for (ImportedServiceDeclaration declaration : declarations) {
                    declaration.visibleIn(visibility);
                }
                return this;
            }

            public ImportedServiceDeclaration importedBy(Class<? extends ServiceImporter> serviceImporterClass) {
                for (ImportedServiceDeclaration declaration : declarations) {
                    declaration.importedBy(serviceImporterClass);
                }
                return this;
            }

            public ImportedServiceDeclaration identifiedBy(String identity) {
                for (ImportedServiceDeclaration declaration : declarations) {
                    declaration.identifiedBy(identity);
                }
                return this;
            }

            public ImportedServiceDeclaration taggedWith(String ... tags) {
                for (ImportedServiceDeclaration declaration : declarations) {
                    declaration.taggedWith(tags);
                }
                return this;
            }

            public ImportedServiceDeclaration setMetaInfo(Object serviceAttribute) {
                for (ImportedServiceDeclaration declaration : declarations) {
                    declaration.setMetaInfo(serviceAttribute);
                }
                return this;
            }

            @SafeVarargs
            public final ImportedServiceDeclaration withActivators(Class<? extends Activator<?>> ... activators) {
                for (ImportedServiceDeclaration declaration : declarations) {
                    declaration.withActivators((Class[])activators);
                }
                return this;
            }
        };
    }

    Collection<ModuleAssemblyImpl> moduleAssemblies() {
        return this.moduleAssemblies.values();
    }

    Set<LayerAssembly> uses() {
        return this.uses;
    }

    public MetaInfo metaInfo() {
        return this.metaInfo;
    }

    public String name() {
        return this.name;
    }

    public List<Class<? extends Activator<Layer>>> activators() {
        return this.activators;
    }

    public final String toString() {
        return "LayerAssembly [" + this.name + "]";
    }
}

