/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Function;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.composite.ConstructorsModel;
import org.qi4j.runtime.composite.FragmentClassLoader;
import org.qi4j.runtime.composite.ProxyReferenceInvocationHandler;
import org.qi4j.runtime.composite.TypedModifierInvocationHandler;
import org.qi4j.runtime.injection.Dependencies;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectedFieldsModel;
import org.qi4j.runtime.injection.InjectedMethodsModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.spi.module.ModuleSpi;

public abstract class AbstractModifierModel
implements Dependencies,
VisitableHierarchy<Object, Object> {
    private final Class<?> modifierClass;
    private final ConstructorsModel constructorsModel;
    private final InjectedFieldsModel injectedFieldsModel;
    private final InjectedMethodsModel injectedMethodsModel;
    private final Class<?>[] nextInterfaces;

    public AbstractModifierModel(Class<?> declaredModifierClass, Class<?> instantiationClass) {
        this.modifierClass = instantiationClass;
        this.constructorsModel = new ConstructorsModel(this.modifierClass);
        this.injectedFieldsModel = new InjectedFieldsModel(declaredModifierClass);
        this.injectedMethodsModel = new InjectedMethodsModel(declaredModifierClass);
        Class componentType = (Class)Class.class.cast(Class.class);
        this.nextInterfaces = (Class[])Iterables.toArray((Class)componentType, (Iterable)Iterables.unique((Iterable)Iterables.map((Function)Classes.RAW_CLASS, (Iterable)Classes.interfacesOf(declaredModifierClass))));
    }

    public Class<?> modifierClass() {
        return this.modifierClass;
    }

    @Override
    public Iterable<DependencyModel> dependencies() {
        return Iterables.flattenIterables((Iterable)Iterables.map((Function)DEPENDENCIES_FUNCTION, (Iterable)Iterables.iterable((Object[])new Dependencies[]{this.constructorsModel, this.injectedFieldsModel, this.injectedMethodsModel})));
    }

    public boolean isGeneric() {
        return InvocationHandler.class.isAssignableFrom(this.modifierClass);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        if (visitor.visitEnter((Object)this) && this.constructorsModel.accept(visitor) && this.injectedFieldsModel.accept(visitor)) {
            this.injectedMethodsModel.accept(visitor);
        }
        return visitor.visitLeave((Object)this);
    }

    public InvocationHandler newInstance(ModuleSpi moduleInstance, InvocationHandler next, ProxyReferenceInvocationHandler proxyHandler, Method method) {
        InjectionContext injectionContext = new InjectionContext(moduleInstance, this.wrapNext(next), proxyHandler);
        Object modifier = this.constructorsModel.newInstance(injectionContext);
        try {
            if (FragmentClassLoader.isGenerated(modifier)) {
                modifier.getClass().getField("_instance").set(modifier, proxyHandler);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        this.injectedFieldsModel.inject(injectionContext, modifier);
        this.injectedMethodsModel.inject(injectionContext, modifier);
        if (this.isGeneric()) {
            return (InvocationHandler)modifier;
        }
        try {
            Method invocationMethod = this.modifierClass.getMethod("_" + method.getName(), method.getParameterTypes());
            TypedModifierInvocationHandler handler = new TypedModifierInvocationHandler();
            handler.setFragment(modifier);
            handler.setMethod(invocationMethod);
            return handler;
        }
        catch (NoSuchMethodException e) {
            throw new ConstructionException("Could not find modifier method", (Throwable)e);
        }
    }

    private Object wrapNext(InvocationHandler next) {
        if (this.isGeneric()) {
            return next;
        }
        return Proxy.newProxyInstance(this.modifierClass.getClassLoader(), this.nextInterfaces, next);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractModifierModel that = (AbstractModifierModel)o;
        return this.modifierClass.equals(that.modifierClass);
    }

    public int hashCode() {
        return this.modifierClass.hashCode();
    }
}

