/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Set;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.composite.InvalidCompositeException;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.composite.CompositeMethodsModel;
import org.qi4j.runtime.composite.MixinsInstance;
import org.qi4j.runtime.composite.MixinsModel;
import org.qi4j.runtime.composite.ProxyGenerator;
import org.qi4j.runtime.composite.StateModel;
import org.qi4j.runtime.composite.TransientClassLoader;
import org.qi4j.runtime.injection.Dependencies;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.spi.module.ModuleSpi;

public abstract class CompositeModel
implements VisitableHierarchy<Object, Object>,
Dependencies,
CompositeDescriptor {
    protected final MixinsModel mixinsModel;
    protected final CompositeMethodsModel compositeMethodsModel;
    private final Set<Class<?>> types;
    private final Visibility visibility;
    private final MetaInfo metaInfo;
    protected final StateModel stateModel;
    protected Class<? extends Composite> proxyClass;
    protected Constructor<? extends Composite> proxyConstructor;

    protected CompositeModel(Iterable<Class<?>> types, Visibility visibility, MetaInfo metaInfo, MixinsModel mixinsModel, StateModel stateModel, CompositeMethodsModel compositeMethodsModel) {
        this.types = (Set)Iterables.addAll(new LinkedHashSet(), types);
        this.visibility = visibility;
        this.metaInfo = metaInfo;
        this.stateModel = stateModel;
        this.compositeMethodsModel = compositeMethodsModel;
        this.mixinsModel = mixinsModel;
        this.createProxyClass();
    }

    public Iterable<Class<?>> types() {
        return this.types;
    }

    public StateModel state() {
        return this.stateModel;
    }

    public <T> T metaInfo(Class<T> infoType) {
        return (T)this.metaInfo.get(infoType);
    }

    public Visibility visibility() {
        return this.visibility;
    }

    public boolean isAssignableTo(Class<?> type) {
        for (Class<?> aClass : this.types) {
            if (!type.isAssignableFrom(aClass)) continue;
            return true;
        }
        return false;
    }

    public MixinsModel mixinsModel() {
        return this.mixinsModel;
    }

    public Class<?> primaryType() {
        Class<?> primaryType = null;
        for (Class<?> type : this.mixinTypes()) {
            if (type.getName().equals("scala.ScalaObject")) continue;
            if (primaryType == null) {
                primaryType = type;
                continue;
            }
            if (!primaryType.isAssignableFrom(type)) continue;
            primaryType = type;
        }
        return primaryType;
    }

    public Iterable<Class<?>> mixinTypes() {
        return this.mixinsModel.mixinTypes();
    }

    @Override
    public Iterable<DependencyModel> dependencies() {
        return Iterables.flatten((Iterable[])new Iterable[]{this.mixinsModel.dependencies(), this.compositeMethodsModel.dependencies()});
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        if (visitor.visitEnter((Object)this) && this.compositeMethodsModel.accept(visitor) && this.stateModel.accept(visitor)) {
            this.mixinsModel.accept(visitor);
        }
        return visitor.visitLeave((Object)this);
    }

    private void createProxyClass() {
        Class mainType = (Class)Iterables.first(this.types);
        if (mainType.isInterface()) {
            ClassLoader proxyClassloader = mainType.getClassLoader();
            Class[] interfaces = (Class[])Iterables.toArray(Class.class, (Iterable)Iterables.cast(this.types));
            this.proxyClass = ProxyGenerator.createProxyClass(proxyClassloader, interfaces);
            try {
                this.proxyConstructor = this.proxyClass.getConstructor(InvocationHandler.class);
            }
            catch (NoSuchMethodException e) {
                throw (InvalidCompositeException)new InvalidCompositeException("Could not get proxy constructor").initCause((Throwable)e);
            }
            this.proxyConstructor.setAccessible(true);
        } else {
            try {
                this.proxyClass = new TransientClassLoader(this.getClass().getClassLoader()).loadFragmentClass(mainType);
                this.proxyConstructor = this.proxyClass.getConstructors()[0];
            }
            catch (ClassNotFoundException e) {
                throw (InvalidCompositeException)new InvalidCompositeException("Could not get proxy constructor").initCause((Throwable)e);
            }
        }
    }

    public final Object invoke(MixinsInstance mixins, Object proxy, Method method, Object[] args, ModuleSpi moduleInstance) throws Throwable {
        return this.compositeMethodsModel.invoke(mixins, proxy, method, args, moduleInstance);
    }

    public Composite newProxy(InvocationHandler invocationHandler) throws ConstructionException {
        Class mainType = (Class)Iterables.first(this.types());
        if (mainType.isInterface()) {
            try {
                return (Composite)Composite.class.cast(this.proxyConstructor.newInstance(invocationHandler));
            }
            catch (Exception e) {
                throw new ConstructionException((Throwable)e);
            }
        }
        try {
            Object[] args = new Object[this.proxyConstructor.getParameterTypes().length];
            Composite composite = (Composite)Composite.class.cast(this.proxyConstructor.newInstance(args));
            this.proxyClass.getField("_instance").set(composite, invocationHandler);
            return composite;
        }
        catch (Exception e) {
            throw new ConstructionException((Throwable)e);
        }
    }

    public <T> T newProxy(InvocationHandler invocationHandler, Class<T> mixinType) throws IllegalArgumentException {
        if (!this.mixinsModel.isImplemented(mixinType)) {
            String message = "Composite " + this.primaryType().getName() + " does not implement type " + mixinType.getName();
            throw new IllegalArgumentException(message);
        }
        return mixinType.cast(Proxy.newProxyInstance(mixinType.getClassLoader(), new Class[]{mixinType}, invocationHandler));
    }

    public String toString() {
        return Iterables.toList(this.types).toString();
    }
}

