/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.constraint.ConstraintViolation;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.composite.ValueConstraintsInstance;

public final class ConstraintsInstance {
    private final List<ValueConstraintsInstance> valueConstraintsInstances;

    public ConstraintsInstance(List<ValueConstraintsInstance> parameterConstraints) {
        this.valueConstraintsInstances = parameterConstraints;
    }

    public void checkValid(Object instance, Method method, Object[] params) throws ConstraintViolationException {
        if (this.valueConstraintsInstances.isEmpty()) {
            return;
        }
        ArrayList<ConstraintViolation> violations = null;
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            List<ConstraintViolation> paramViolations = this.valueConstraintsInstances.get(i).checkConstraints(param);
            if (paramViolations.isEmpty()) continue;
            if (violations == null) {
                violations = new ArrayList<ConstraintViolation>();
            }
            violations.addAll(paramViolations);
        }
        if (violations != null) {
            if (instance instanceof Composite) {
                throw new ConstraintViolationException((Composite)instance, (Member)method, violations);
            }
            if (instance instanceof CompositeInstance) {
                throw new ConstraintViolationException((Composite)((CompositeInstance)instance).proxy(), (Member)method, violations);
            }
            Iterable types = Iterables.iterable((Object[])new Class[]{instance.getClass()});
            throw new ConstraintViolationException(instance.toString(), types, (Member)method, violations);
        }
    }
}

