/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.composite.ConstructorDescriptor;
import org.qi4j.api.composite.InvalidCompositeException;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectedParametersModel;
import org.qi4j.runtime.injection.InjectionContext;

public final class ConstructorModel
implements ConstructorDescriptor,
VisitableHierarchy<Object, Object> {
    private Constructor<?> constructor;
    private InjectedParametersModel parameters;

    public ConstructorModel(Constructor<?> constructor, InjectedParametersModel parameters) {
        this.constructor = constructor;
        this.parameters = parameters;
        this.constructor.setAccessible(true);
    }

    public Constructor<?> constructor() {
        return this.constructor;
    }

    public Iterable<DependencyModel> dependencies() {
        return this.parameters.dependencies();
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> modelVisitor) throws ThrowableType {
        if (modelVisitor.visitEnter((Object)this)) {
            this.parameters.accept(modelVisitor);
        }
        return modelVisitor.visitLeave((Object)this);
    }

    public Object newInstance(InjectionContext context) throws ConstructionException {
        Object[] parametersInstance = this.parameters.newParametersInstance(context);
        try {
            return this.constructor.newInstance(parametersInstance);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof InvalidCompositeException) {
                throw (InvalidCompositeException)targetException;
            }
            String message = "Could not instantiate \n    " + this.constructor.getDeclaringClass() + "\nusing constructor:\n    " + this.constructor.toGenericString();
            throw new ConstructionException(message, targetException);
        }
        catch (Throwable e) {
            System.err.println(this.constructor.toGenericString());
            System.err.println(Arrays.asList(parametersInstance));
            throw new ConstructionException("Could not instantiate " + this.constructor.getDeclaringClass(), e);
        }
    }

    public String toString() {
        return this.constructor.toGenericString();
    }
}

