/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.qi4j.runtime.composite.CompactLevel;

abstract class FragmentInvocationHandler
implements InvocationHandler {
    private static final String COMPACT_TRACE = "qi4j.compacttrace";
    private static final CompactLevel compactLevel = CompactLevel.valueOf(System.getProperty("qi4j.compacttrace", "proxy"));
    protected Object fragment;
    protected Method method;

    FragmentInvocationHandler() {
    }

    void setFragment(Object fragment) {
        this.fragment = fragment;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    protected Throwable cleanStackTrace(Throwable throwable, Object proxy, Method method) {
        if (compactLevel == CompactLevel.off) {
            return throwable;
        }
        StackTraceElement[] trace = throwable.getStackTrace();
        if (trace.length == 0 || !this.isApplicationClass(trace[0].getClassName())) {
            return throwable;
        }
        int count = 0;
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement stackTraceElement = trace[i];
            if (!this.isApplicationClass(stackTraceElement.getClassName())) {
                trace[i] = null;
                ++count;
                continue;
            }
            boolean classOrigin = stackTraceElement.getClassName().equals(proxy.getClass().getSimpleName());
            boolean methodOrigin = stackTraceElement.getMethodName().equals(method.getName());
            if (!classOrigin || !methodOrigin || compactLevel != CompactLevel.proxy) continue;
            trace[i] = new StackTraceElement(proxy.getClass().getInterfaces()[0].getName(), method.getName(), null, -1);
            break;
        }
        int idx = 0;
        StackTraceElement[] newTrace = new StackTraceElement[trace.length - count];
        for (StackTraceElement stackTraceElement : trace) {
            if (stackTraceElement == null) continue;
            newTrace[idx++] = stackTraceElement;
        }
        throwable.setStackTrace(newTrace);
        Throwable nested = throwable.getCause();
        if (nested != null) {
            this.cleanStackTrace(nested, proxy, method);
        }
        return throwable;
    }

    private boolean isApplicationClass(String className) {
        if (compactLevel == CompactLevel.semi) {
            return !this.isJdkInternals(className);
        }
        return !className.endsWith("_Stub") && !className.startsWith("org.qi4j.runtime") && !this.isJdkInternals(className);
    }

    private boolean isJdkInternals(String className) {
        return className.startsWith("java.lang.reflect") || className.startsWith("com.sun.proxy") || className.startsWith("sun.reflect");
    }
}

